/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.client.ClientProxy;
import com.oitsjustjose.geolosys.client.patchouli.processors.PatronProcessor;
import com.oitsjustjose.geolosys.client.render.Cutouts;
import com.oitsjustjose.geolosys.common.CommonProxy;
import com.oitsjustjose.geolosys.common.blocks.ModBlocks;
import com.oitsjustjose.geolosys.common.config.ClientConfig;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.WorldGenDataLoader;
import com.oitsjustjose.geolosys.common.data.modifiers.OsmiumDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.QuartzDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.SulfurDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.YelloriumDropModifier;
import com.oitsjustjose.geolosys.common.event.ManualGifting;
import com.oitsjustjose.geolosys.common.items.ModItems;
import com.oitsjustjose.geolosys.common.utils.Constants;
import com.oitsjustjose.geolosys.common.world.GeolosysFeatures;
import com.oitsjustjose.geolosys.common.world.capability.DepositCapability;
import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="geolosys")
public class Geolosys {
    private static Geolosys instance;
    public static CommonProxy proxy;
    public Logger LOGGER = LogManager.getLogger();

    public Geolosys() {
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ManualGifting());
        this.configSetup();
    }

    public static Geolosys getInstance() {
        return instance;
    }

    private void configSetup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        CommonConfig.loadConfig(CommonConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("geolosys-common.toml"));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Cutouts.init();
    }

    public void setup(FMLCommonSetupEvent event) {
        GeolosysAPI.init();
        PatronProcessor.fetchPatrons();
        proxy.init();
    }

    @SubscribeEvent
    public void onSlashReload(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)new WorldGenDataLoader());
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(DepositCapability.class);
    }

    @SubscribeEvent
    public void attachWorldCaps(AttachCapabilitiesEvent<Level> event) {
        if (((Level)event.getObject()).m_5776_()) {
            return;
        }
        try {
            final LazyOptional inst = LazyOptional.of(() -> new DepositCapability());
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return DepositCapability.CAPABILITY.orEmpty(cap, inst);
                }

                public CompoundTag serializeNBT() {
                    IDepositCapability cap = (IDepositCapability)this.getCapability(DepositCapability.CAPABILITY).orElse(null);
                    return cap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    IDepositCapability cap = (IDepositCapability)this.getCapability(DepositCapability.CAPABILITY).orElse(null);
                    cap.deserializeNBT(nbt);
                }
            };
            event.addCapability(Constants.CAPABILITY_NAME, (ICapabilityProvider)provider);
            event.addListener(() -> inst.invalidate());
        }
        catch (Exception e) {
            this.LOGGER.error("Geolosys has faced a fatal error. The game will crash...");
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onHover(ItemTooltipEvent event) {
        Collection tags;
        if (!((Boolean)ClientConfig.ENABLE_TAG_DEBUG.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92125_ && (tags = ItemTags.m_13193_().m_13394_((Object)event.getItemStack().m_41720_())).size() > 0) {
            for (ResourceLocation tag : tags) {
                event.getToolTip().add(new TextComponent("\u00a78#" + tag.toString() + "\u00a7r"));
            }
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            ModBlocks.getInstance().register(blockRegistryEvent);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            ModBlocks.getInstance().registerItemBlocks(itemRegistryEvent);
            ModItems.getInstance().register(itemRegistryEvent);
        }

        @SubscribeEvent
        public static void onFeaturesRegistry(RegistryEvent.Register<Feature<?>> featureRegistryEvent) {
            GeolosysFeatures.register(featureRegistryEvent);
        }

        @SubscribeEvent
        public static void onModifierSerializersRegistry(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
            evt.getRegistry().register((IForgeRegistryEntry)new OsmiumDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "osmium")));
            evt.getRegistry().register((IForgeRegistryEntry)new QuartzDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "quartzes")));
            evt.getRegistry().register((IForgeRegistryEntry)new YelloriumDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "yellorium")));
            evt.getRegistry().register((IForgeRegistryEntry)new SulfurDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "sulfur")));
        }
    }
}

