/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import com.oitsjustjose.geolosys.common.blocks.OreBlock;
import com.oitsjustjose.geolosys.common.blocks.PeatBlock;
import com.oitsjustjose.geolosys.common.blocks.PlantBlock;
import com.oitsjustjose.geolosys.common.blocks.SampleBlock;
import com.oitsjustjose.geolosys.common.blocks.Types;
import com.oitsjustjose.geolosys.common.utils.GeolosysGroup;
import java.util.ArrayList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    private static ModBlocks instance;
    private ArrayList<Block> extras = new ArrayList();
    public Block peat = (Block)new PeatBlock().setRegistryName("geolosys", "peat");
    public Block rhododendron = (Block)new PlantBlock(false, this.peat).setRegistryName("geolosys", "rhododendron");

    private ModBlocks() {
        for (Types.Ores ores : Types.Ores.values()) {
            String SAMPLE_REGISTRY_NAME = ores.getUnlocalizedName().toLowerCase() + "_ore_sample";
            String ORE_REGISTRY_NAME = ores.getUnlocalizedName().toLowerCase() + "_ore";
            BlockBehaviour.Properties blockProp = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_();
            Block block = (Block)new OreBlock(blockProp, ores.getXp()).setRegistryName("geolosys", ORE_REGISTRY_NAME);
            Block sample = (Block)new SampleBlock().setRegistryName("geolosys", SAMPLE_REGISTRY_NAME);
            ores.setSample(sample);
            ores.setBlock(block);
        }
        for (Enum enum_ : Types.DeepslateOres.values()) {
            String ORE_REGISTRY_NAME = ((Types.DeepslateOres)enum_).getUnlocalizedName().toLowerCase() + "_ore";
            BlockBehaviour.Properties blockProp = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_164534_).m_60913_(7.5f, 10.0f).m_60918_(SoundType.f_154677_).m_60999_();
            Block block = (Block)new OreBlock(blockProp, ((Types.DeepslateOres)enum_).getXp()).setRegistryName("geolosys", ORE_REGISTRY_NAME);
            ((Types.DeepslateOres)enum_).setBlock(block);
            ((Types.DeepslateOres)enum_).setSample(((Types.DeepslateOres)enum_).getOrigin().getSample());
        }
        this.extras.add(this.peat);
        this.extras.add(this.rhododendron);
    }

    public static ModBlocks getInstance() {
        if (instance == null) {
            instance = new ModBlocks();
        }
        return instance;
    }

    public void register(RegistryEvent.Register<Block> blockRegistryEvent) {
        for (Types.Ores ores : Types.Ores.values()) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ores.getBlock());
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ores.getSample());
        }
        for (Enum enum_ : Types.DeepslateOres.values()) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)((Types.DeepslateOres)enum_).getBlock());
        }
        for (Block extra : this.extras) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)extra);
        }
    }

    public void registerItemBlocks(RegistryEvent.Register<Item> itemRegistryEvent) {
        Item iBlock;
        for (Types.Ores ores : Types.Ores.values()) {
            iBlock = (Item)new BlockItem(ores.getBlock(), new Item.Properties().m_41491_((CreativeModeTab)GeolosysGroup.getInstance())).setRegistryName(ores.getBlock().getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
        }
        for (Types.Ores ores : Types.Ores.values()) {
            iBlock = (Item)new BlockItem(ores.getSample(), new Item.Properties().m_41491_((CreativeModeTab)GeolosysGroup.getInstance())).setRegistryName(ores.getSample().getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
        }
        for (Enum enum_ : Types.DeepslateOres.values()) {
            iBlock = (Item)new BlockItem(((Types.DeepslateOres)enum_).getBlock(), new Item.Properties().m_41491_((CreativeModeTab)GeolosysGroup.getInstance())).setRegistryName(((Types.DeepslateOres)enum_).getBlock().getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
        }
        for (Block extra : this.extras) {
            Item iBlock2 = (Item)new BlockItem(extra, new Item.Properties().m_41491_((CreativeModeTab)GeolosysGroup.getInstance())).setRegistryName(extra.getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock2);
        }
    }
}

