/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class QuartzDropModifier
extends LootModifier {
    private Random rand = new Random();
    private HashMap<Item, Float> quartzes;
    private float chance;

    public QuartzDropModifier(LootItemCondition[] conditions, HashMap<Item, Float> quartzes, float chance) {
        super(conditions);
        this.quartzes = quartzes;
        this.chance = chance;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> gennedLoot, LootContext ctx) {
        ItemStack ctxTool = (ItemStack)ctx.m_165124_(LootContextParams.f_81463_);
        if (ctxTool != null && !ctxTool.m_41619_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)ctxTool) > 0) {
            return gennedLoot;
        }
        if (this.rand.nextFloat() < this.chance) {
            gennedLoot.add(new ItemStack((ItemLike)this.pick(), 1));
        }
        return gennedLoot;
    }

    private Item pick() {
        float rng = this.rand.nextFloat();
        float minDist = Float.MAX_VALUE;
        Item minDistItem = null;
        for (Map.Entry<Item, Float> e : this.quartzes.entrySet()) {
            float dist = Math.abs(e.getValue().floatValue() - rng);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minDistItem = e.getKey();
        }
        return minDistItem;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<QuartzDropModifier> {
        public QuartzDropModifier read(ResourceLocation name, JsonObject obj, LootItemCondition[] cond) {
            JsonArray a = GsonHelper.m_13933_((JsonObject)obj, (String)"quartzes");
            HashMap<Item, Float> quartzes = new HashMap<Item, Float>();
            float occChance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
            a.forEach(el -> {
                JsonObject j = el.getAsJsonObject();
                String resLoc = GsonHelper.m_13906_((JsonObject)j, (String)"item");
                float chance = GsonHelper.m_13915_((JsonObject)j, (String)"chance");
                Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resLoc));
                if (i != null && i != Items.f_41852_) {
                    quartzes.put(i, Float.valueOf(chance));
                }
            });
            return new QuartzDropModifier(cond, quartzes, occChance);
        }

        public JsonObject write(QuartzDropModifier instance) {
            JsonObject obj = this.makeConditions(instance.conditions);
            JsonArray a = new JsonArray();
            instance.quartzes.forEach((q, c) -> {
                JsonObject entry = new JsonObject();
                entry.addProperty("item", q.getRegistryName().toString());
                entry.addProperty("chance", (Number)c);
                a.add((JsonElement)entry);
            });
            obj.addProperty("chance", (Number)Float.valueOf(0.5f));
            obj.add("quartzes", (JsonElement)a);
            return obj;
        }
    }
}

