/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.modifiers;

import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.common.config.CompatConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class SulfurDropModifier
extends LootModifier {
    private Random rand = new Random();
    private float chance;
    private Item item;
    private String tag;
    private int qty;

    public SulfurDropModifier(LootItemCondition[] conditions, Item item, String tag, float chance, int qty) {
        super(conditions);
        this.chance = chance;
        this.item = item;
        this.tag = tag;
        this.qty = qty;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> gennedLoot, LootContext ctx) {
        if (this.item == null) {
            return gennedLoot;
        }
        ItemStack ctxTool = (ItemStack)ctx.m_165124_(LootContextParams.f_81463_);
        if (ctxTool != null && !ctxTool.m_41619_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)ctxTool) > 0) {
            return gennedLoot;
        }
        if (!((Boolean)CompatConfig.ENABLE_SULFUR.get()).booleanValue()) {
            return gennedLoot;
        }
        if (this.rand.nextFloat() < this.chance) {
            gennedLoot.add(new ItemStack((ItemLike)this.item, this.qty));
        }
        return gennedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SulfurDropModifier> {
        public SulfurDropModifier read(ResourceLocation name, JsonObject obj, LootItemCondition[] cond) {
            Item i = null;
            String tag = GsonHelper.m_13906_((JsonObject)obj, (String)"tag");
            float chance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
            int qty = GsonHelper.m_13927_((JsonObject)obj, (String)"qty");
            ResourceLocation tagRes = new ResourceLocation(tag);
            Tag itemTag = ItemTags.m_13193_().m_13404_(tagRes);
            if (itemTag != null && itemTag.m_6497_().size() > 0) {
                i = (Item)itemTag.m_6497_().get(0);
            }
            return new SulfurDropModifier(cond, i, tag, chance, qty);
        }

        public JsonObject write(SulfurDropModifier instance) {
            JsonObject obj = this.makeConditions(instance.conditions);
            obj.addProperty("tag", instance.tag);
            obj.addProperty("chance", (Number)Float.valueOf(instance.chance));
            obj.addProperty("qty", (Number)instance.qty);
            return obj;
        }
    }
}

