/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.network;

import com.oitsjustjose.geolosys.common.network.PacketHelpers;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class PacketStackUnderground {
    public HashSet<BlockState> blocks;
    public String direction;

    public PacketStackUnderground(FriendlyByteBuf buf) {
        CompoundTag comp = buf.m_130260_();
        this.blocks = PacketHelpers.decodeBlocks(comp);
        this.direction = buf.m_130277_();
    }

    public PacketStackUnderground(HashSet<BlockState> d1, String d2) {
        this.blocks = d1;
        this.direction = d2;
    }

    public static PacketStackUnderground decode(FriendlyByteBuf buf) {
        return new PacketStackUnderground(buf);
    }

    public static void encode(PacketStackUnderground msg, FriendlyByteBuf buf) {
        buf.m_130079_(PacketHelpers.encodeBlocks(msg.blocks));
        buf.m_130070_(msg.direction);
    }

    public void handleServer(Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(PacketStackUnderground msg, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.get().enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                PacketStackUnderground.sendProspectingMessage(mc.f_91074_, PacketHelpers.messagify(msg.blocks), msg.direction);
            });
        }
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendProspectingMessage(LocalPlayer player, Object ... messageDecorators) {
        TranslatableComponent msg = new TranslatableComponent("geolosys.pro_pick.tooltip.found", messageDecorators);
        player.m_5661_((Component)msg, true);
    }
}

