/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OreRemover {
    private static List<Block> toRm = Arrays.asList(Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50122_, Blocks.f_50226_, Blocks.f_152596_, Blocks.f_152505_, Blocks.f_49996_, Blocks.f_49997_, Blocks.f_50059_, Blocks.f_50089_, Blocks.f_50264_, Blocks.f_49995_, Blocks.f_50173_, Blocks.f_50331_, Blocks.f_49998_, Blocks.f_50722_, Blocks.f_152506_, Blocks.f_152468_, Blocks.f_152469_, Blocks.f_152472_, Blocks.f_152474_, Blocks.f_152479_, Blocks.f_152467_, Blocks.f_152473_);

    private static List<ConfiguredFeature<?, ?>> featureRemover(Block targetBlock, ConfiguredFeature<?, ?> targetFeature) {
        LinkedList removed = new LinkedList();
        if (targetBlock != null && toRm.contains(targetBlock)) {
            removed.add(targetFeature);
            if (((Boolean)CommonConfig.ADVANCED_DEBUG_WORLD_GEN.get()).booleanValue()) {
                Geolosys.getInstance().LOGGER.info("{} removed from worldgen", (Object)targetBlock.getRegistryName());
            }
        }
        return removed;
    }

    public static List<Supplier<PlacedFeature>> filterFeatures(List<Supplier<PlacedFeature>> features) {
        LinkedList<Supplier<PlacedFeature>> removed = new LinkedList<Supplier<PlacedFeature>>();
        for (Supplier<PlacedFeature> feature : features) {
            feature.get().m_191781_().forEach(confFeat -> {
                List mapped;
                List targets = null;
                if (confFeat.f_65378_ instanceof OreConfiguration) {
                    targets = ((OreConfiguration)confFeat.f_65378_).f_161005_;
                } else if (confFeat.f_65378_ instanceof ReplaceBlockConfiguration) {
                    targets = ((ReplaceBlockConfiguration)confFeat.f_65378_).f_161083_;
                }
                if (targets != null && (mapped = targets.parallelStream().map(t -> OreRemover.featureRemover(t.f_161033_.m_60734_(), confFeat).size() > 0).collect(Collectors.toList())).contains(true)) {
                    removed.add(feature);
                }
            });
        }
        return removed;
    }
}

