/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.capability;

import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class DepositCapability
implements IDepositCapability {
    private Map<BlockPos, BlockState> pendingBlocks = new ConcurrentHashMap<BlockPos, BlockState>();
    public static final Capability<IDepositCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDepositCapability>(){});

    @Override
    public void putPendingBlock(BlockPos pos, BlockState state) {
        this.pendingBlocks.put(pos, state);
    }

    @Override
    public void removePendingBlock(BlockPos pos, BlockState state) {
        this.pendingBlocks.remove(pos, state);
    }

    @Override
    public Map<BlockPos, BlockState> getPendingBlocks(ChunkPos chunkPos) {
        ConcurrentHashMap<BlockPos, BlockState> ret = new ConcurrentHashMap<BlockPos, BlockState>();
        this.pendingBlocks.forEach((pos, state) -> {
            ChunkPos tmp = new ChunkPos(pos);
            if (chunkPos == tmp) {
                ret.put((BlockPos)pos, (BlockState)state);
            }
        });
        return ret;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag pendingBlocks = new ListTag();
        this.pendingBlocks.forEach((pos, state) -> {
            CompoundTag tmp = new CompoundTag();
            CompoundTag posTag = NbtUtils.m_129224_((BlockPos)pos);
            CompoundTag stateTag = NbtUtils.m_129202_((BlockState)state);
            tmp.m_128365_("pos", (Tag)posTag);
            tmp.m_128365_("state", (Tag)stateTag);
            pendingBlocks.add((Object)tmp);
        });
        compound.m_128365_("pending", (Tag)pendingBlocks);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        ListTag pending = compound.m_128437_("pending", 10);
        pending.forEach(tmp -> {
            CompoundTag comp = (CompoundTag)tmp;
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)comp.m_128469_("pos"));
            BlockState state = NbtUtils.m_129241_((CompoundTag)comp.m_128469_("state"));
            this.putPendingBlock(pos, state);
        });
    }
}

