/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.capability.DepositCapability;
import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DepositFeature
extends Feature<NoneFeatureConfiguration> {
    public DepositFeature(Codec<NoneFeatureConfiguration> p_i231976_1_) {
        super(p_i231976_1_);
    }

    public final DepositFeature withRegistryName(String modID, String name) {
        this.setRegistryName(new ResourceLocation(modID, name));
        return this;
    }

    @ParametersAreNonnullByDefault
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> f) {
        if (f.m_159775_() instanceof FlatLevelSource) {
            return false;
        }
        WorldGenLevel level = f.m_159774_();
        BlockPos pos = f.m_159777_();
        if (level.m_5822_().nextDouble() < (Double)CommonConfig.CHUNK_SKIP_CHANCE.get()) {
            return false;
        }
        IDepositCapability cap = (IDepositCapability)level.m_6018_().getCapability(DepositCapability.CAPABILITY).orElse(null);
        if (cap == null) {
            Geolosys.getInstance().LOGGER.error("NULL PLUTON CAPABILITY!!!");
            return false;
        }
        boolean placedPending = this.placePendingBlocks(level, cap, pos);
        boolean placedPluton = false;
        for (int p = 0; p < (Integer)CommonConfig.NUMBER_PLUTONS_PER_CHUNK.get(); ++p) {
            boolean anyGenerated;
            IDeposit pluton = GeolosysAPI.plutonRegistry.pick(level, pos);
            if (pluton == null) continue;
            boolean bl = anyGenerated = pluton.generate(level, pos, cap) > 0;
            if (!anyGenerated) continue;
            placedPluton = true;
            pluton.afterGen(level, pos, cap);
        }
        return placedPluton || placedPending;
    }

    private boolean placePendingBlocks(WorldGenLevel level, IDepositCapability cap, BlockPos origin) {
        ChunkPos cp = new ChunkPos(origin);
        Map<BlockPos, BlockState> forThisChunk = cap.getPendingBlocks(cp);
        forThisChunk.forEach((pos, state) -> level.m_7731_(pos, state, 18));
        forThisChunk.forEach((pos, state) -> cap.removePendingBlock((BlockPos)pos, (BlockState)state));
        return forThisChunk.size() > 0;
    }
}

