/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.oitsjustjose.geolosys.Registry;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.capability.deposit.DepositCapability;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.player.IPlayerCapability;
import com.oitsjustjose.geolosys.capability.player.PlayerCapability;
import com.oitsjustjose.geolosys.capability.world.ChunkGennedCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.client.ClientProxy;
import com.oitsjustjose.geolosys.client.GeolosysClient;
import com.oitsjustjose.geolosys.client.patchouli.processors.PatronProcessor;
import com.oitsjustjose.geolosys.client.render.Cutouts;
import com.oitsjustjose.geolosys.common.CommonProxy;
import com.oitsjustjose.geolosys.common.config.ClientConfig;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.WorldGenDataLoader;
import com.oitsjustjose.geolosys.common.data.modifiers.OsmiumDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.QuartzDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.SulfurDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.YelloriumDropModifier;
import com.oitsjustjose.geolosys.common.event.ManualGifting;
import com.oitsjustjose.geolosys.common.items.Types;
import com.oitsjustjose.geolosys.common.utils.Constants;
import com.oitsjustjose.geolosys.common.world.GeolosysFeatures;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="geolosys")
public class Geolosys {
    private static Geolosys instance;
    public static CommonProxy proxy;
    public Logger LOGGER = LogManager.getLogger();

    public Geolosys() {
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Registry.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> GeolosysClient::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ManualGifting());
        this.configSetup();
    }

    public static Geolosys getInstance() {
        return instance;
    }

    private void configSetup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        CommonConfig.loadConfig(CommonConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("geolosys-common.toml"));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Cutouts.init();
    }

    public void setup(FMLCommonSetupEvent event) {
        GeolosysAPI.init();
        PatronProcessor.fetchPatrons();
        proxy.init();
    }

    @SubscribeEvent
    public void onSlashReload(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)new WorldGenDataLoader());
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(DepositCapability.class);
        event.register(PlayerCapability.class);
        event.register(ChunkGennedCapability.class);
    }

    @SubscribeEvent
    public void attachWorldCaps(AttachCapabilitiesEvent<Level> event) {
        Object provider;
        LazyOptional inst;
        if (((Level)event.getObject()).m_5776_()) {
            return;
        }
        try {
            inst = LazyOptional.of(DepositCapability::new);
            provider = new ICapabilitySerializable<CompoundTag>(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
                    return DepositCapability.CAPABILITY.orEmpty(cap, inst);
                }

                public CompoundTag serializeNBT() {
                    IDepositCapability cap = (IDepositCapability)this.getCapability(DepositCapability.CAPABILITY).orElseThrow(RuntimeException::new);
                    return cap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    IDepositCapability cap = (IDepositCapability)this.getCapability(DepositCapability.CAPABILITY).orElseThrow(RuntimeException::new);
                    cap.deserializeNBT(nbt);
                }
            };
            event.addCapability(Constants.DEPOSIT_CAPABILITY_NAME, (ICapabilityProvider)provider);
            event.addListener(() -> ((LazyOptional)inst).invalidate());
        }
        catch (Exception e) {
            this.LOGGER.error("Geolosys has faced a fatal error. The game will crash...");
            throw new RuntimeException(e);
        }
        try {
            inst = LazyOptional.of(PlayerCapability::new);
            provider = new ICapabilitySerializable<CompoundTag>(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
                    return PlayerCapability.CAPABILITY.orEmpty(cap, inst);
                }

                public CompoundTag serializeNBT() {
                    IPlayerCapability cap = (IPlayerCapability)this.getCapability(PlayerCapability.CAPABILITY).orElseThrow(RuntimeException::new);
                    return cap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    IPlayerCapability cap = (IPlayerCapability)this.getCapability(PlayerCapability.CAPABILITY).orElseThrow(RuntimeException::new);
                    cap.deserializeNBT(nbt);
                }
            };
            event.addCapability(Constants.PLAYER_CAPABILITY_NAME, (ICapabilityProvider)provider);
            event.addListener(() -> ((LazyOptional)inst).invalidate());
        }
        catch (Exception e) {
            this.LOGGER.error("Geolosys has faced a fatal error. The game will crash...");
            throw new RuntimeException(e);
        }
        try {
            inst = LazyOptional.of(ChunkGennedCapability::new);
            provider = new ICapabilitySerializable<CompoundTag>(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
                    return ChunkGennedCapability.CAPABILITY.orEmpty(cap, inst);
                }

                public CompoundTag serializeNBT() {
                    IChunkGennedCapability cap = (IChunkGennedCapability)this.getCapability(ChunkGennedCapability.CAPABILITY).orElseThrow(RuntimeException::new);
                    return cap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    IChunkGennedCapability cap = (IChunkGennedCapability)this.getCapability(ChunkGennedCapability.CAPABILITY).orElseThrow(RuntimeException::new);
                    cap.deserializeNBT(nbt);
                }
            };
            event.addCapability(Constants.CHUNKGEN_CAPABILITY_NAME, (ICapabilityProvider)provider);
            event.addListener(() -> ((LazyOptional)inst).invalidate());
        }
        catch (Exception e) {
            this.LOGGER.error("Geolosys has faced a fatal error. The game will crash...");
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onFuelRegistry(FurnaceFuelBurnTimeEvent fuelBurnoutEvent) {
        for (Types.Coals c : Types.Coals.values()) {
            if (!fuelBurnoutEvent.getItemStack().m_41720_().equals(c.getItem())) continue;
            fuelBurnoutEvent.setBurnTime(c.getBurnTime() * 200);
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onFeaturesRegistry(RegistryEvent.Register<Feature<?>> featureRegistryEvent) {
            GeolosysFeatures.register(featureRegistryEvent);
        }

        @SubscribeEvent
        public static void onModifierSerializersRegistry(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
            evt.getRegistry().register((IForgeRegistryEntry)new OsmiumDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "osmium")));
            evt.getRegistry().register((IForgeRegistryEntry)new QuartzDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "quartzes")));
            evt.getRegistry().register((IForgeRegistryEntry)new YelloriumDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "yellorium")));
            evt.getRegistry().register((IForgeRegistryEntry)new SulfurDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "sulfur")));
        }
    }
}

