/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.oitsjustjose.geolosys.common.blocks.OreBlock;
import com.oitsjustjose.geolosys.common.blocks.PeatBlock;
import com.oitsjustjose.geolosys.common.blocks.PlantBlock;
import com.oitsjustjose.geolosys.common.blocks.SampleBlock;
import com.oitsjustjose.geolosys.common.blocks.Types;
import com.oitsjustjose.geolosys.common.items.CoalItem;
import com.oitsjustjose.geolosys.common.items.ProPickItem;
import com.oitsjustjose.geolosys.common.items.Types;
import com.oitsjustjose.geolosys.common.utils.GeolosysGroup;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registry {
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"geolosys");
    public static DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"geolosys");
    public static RegistryObject<Block> PEAT;
    public static RegistryObject<Block> RHODODENDRON;
    public static RegistryObject<Item> PRO_PICK;
    public static TagKey<Block> SUPPORTS_SAMPLE;

    public static void register(IEventBus modbus) {
        Registry.registerBlocks();
        Registry.registerItems();
        BLOCKS.register(modbus);
        ITEMS.register(modbus);
    }

    private static void registerBlocks() {
        for (Types.Ores ores : Types.Ores.values()) {
            Registry.registerOre(ores);
        }
        for (Enum enum_ : Types.DeepslateOres.values()) {
            Registry.registerDeepslateOre((Types.DeepslateOres)enum_);
        }
        PEAT = BLOCKS.register("peat", PeatBlock::new);
        ITEMS.register("peat", Registry.itemOf(PEAT));
        RHODODENDRON = BLOCKS.register("rhododendron", () -> new PlantBlock(false, PEAT));
        ITEMS.register("rhododendron", Registry.itemOf(RHODODENDRON));
    }

    private static void registerItems() {
        RegistryObject item;
        Item.Properties genericItemProps = new Item.Properties().m_41491_((CreativeModeTab)GeolosysGroup.getInstance());
        String CLUSTER_POSTFIX = "_cluster";
        String INGOT_POSTFIX = "_ingot";
        String NUGGET_POSTFIX = "_nugget";
        String COAL_POSTFIX = "_coal";
        String COAL_COKE_POSTFIX = "_coal_coke";
        for (Types.Clusters clusters : Types.Clusters.values()) {
            item = ITEMS.register(clusters.getName() + CLUSTER_POSTFIX, () -> new Item(genericItemProps));
            clusters.setItem((RegistryObject<Item>)item);
        }
        for (Enum enum_ : Types.Ingots.values()) {
            item = ITEMS.register(((Types.Ingots)enum_).getName() + INGOT_POSTFIX, () -> new Item(genericItemProps));
            ((Types.Ingots)enum_).setItem((RegistryObject<Item>)item);
        }
        for (Enum enum_ : Types.Nuggets.values()) {
            item = ITEMS.register(((Types.Nuggets)enum_).getName() + NUGGET_POSTFIX, () -> new Item(genericItemProps));
            ((Types.Nuggets)enum_).setItem((RegistryObject<Item>)item);
        }
        for (Enum enum_ : Types.Coals.values()) {
            item = ITEMS.register(((Types.Coals)enum_).getName() + (((Types.Coals)enum_).isCoalCoke() ? COAL_COKE_POSTFIX : COAL_POSTFIX), () -> Registry.lambda$registerItems$4((Types.Coals)enum_));
            ((Types.Coals)enum_).setItem((RegistryObject<Item>)item);
        }
        PRO_PICK = ITEMS.register("prospectors_pick", ProPickItem::new);
    }

    private static void registerOre(Types.Ores o) {
        BlockBehaviour.Properties stoneOreProperties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_();
        String ORE_REGISTRY_NAME = o.getUnlocalizedName().toLowerCase() + "_ore";
        String SAMPLE_REGISTRY_NAME = o.getUnlocalizedName().toLowerCase() + "_ore_sample";
        RegistryObject block = BLOCKS.register(ORE_REGISTRY_NAME, () -> new OreBlock(stoneOreProperties, o.getXp()));
        RegistryObject sample = BLOCKS.register(SAMPLE_REGISTRY_NAME, SampleBlock::new);
        o.setBlock((RegistryObject<Block>)block);
        o.setSample((RegistryObject<Block>)sample);
        ITEMS.register(ORE_REGISTRY_NAME, Registry.itemOf((RegistryObject<Block>)block));
        ITEMS.register(SAMPLE_REGISTRY_NAME, Registry.itemOf((RegistryObject<Block>)sample));
    }

    private static void registerDeepslateOre(Types.DeepslateOres o) {
        BlockBehaviour.Properties deepslateOreProperties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_164534_).m_60913_(7.5f, 10.0f).m_60918_(SoundType.f_154677_).m_60999_();
        String ORE_REGISTRY_NAME = o.getUnlocalizedName().toLowerCase() + "_ore";
        RegistryObject block = BLOCKS.register(ORE_REGISTRY_NAME, () -> new OreBlock(deepslateOreProperties, o.getXp()));
        o.setBlock((RegistryObject<Block>)block);
        o.setSample(o.getOrigin().getSample());
        ITEMS.register(ORE_REGISTRY_NAME, Registry.itemOf((RegistryObject<Block>)block));
    }

    private static Supplier<Item> itemOf(RegistryObject<Block> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_((CreativeModeTab)GeolosysGroup.getInstance()));
    }

    private static /* synthetic */ Item lambda$registerItems$4(Types.Coals coal) {
        return new CoalItem(coal);
    }

    static {
        SUPPORTS_SAMPLE = BlockTags.create((ResourceLocation)new ResourceLocation("geolosys", "supports_sample"));
    }
}

