/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class DepositUtils {
    private static Random random = new Random();
    private static HashSet<BlockState> defaultMatchersCached = null;

    @Nullable
    public static BlockState pick(HashMap<BlockState, Float> map, float totl) {
        float rng = random.nextFloat();
        for (Map.Entry<BlockState, Float> e : map.entrySet()) {
            float wt = e.getValue().floatValue();
            if (rng < wt) {
                return e.getKey();
            }
            rng -= wt;
        }
        Geolosys.getInstance().LOGGER.error("Could not reach decision on block to place at Utils#pick");
        return null;
    }

    public static boolean canPlaceInBiome(Holder<Biome> targetBiome, @Nullable List<Biome> biomes, @Nullable List<BiomeDictionary.Type> biomeTypes, boolean isBiomeFilterBl) {
        boolean matchForBiome = false;
        boolean matchForBiomeType = false;
        if (biomes != null) {
            matchForBiome = biomes.stream().anyMatch(b -> targetBiome.m_203373_(b.getRegistryName()));
        }
        if (biomeTypes != null) {
            matchForBiomeType = biomeTypes.stream().anyMatch(t -> BiomeDictionary.getBiomes((BiomeDictionary.Type)t).stream().anyMatch(b -> targetBiome.m_203373_(b.m_135782_())));
        }
        return (matchForBiome || matchForBiomeType) && !isBiomeFilterBl || !matchForBiome && !matchForBiomeType && isBiomeFilterBl;
    }

    public static HashSet<BlockState> getDefaultMatchers() {
        if (defaultMatchersCached == null) {
            defaultMatchersCached = new HashSet();
            ((List)CommonConfig.DEFAULT_REPLACEMENT_MATS.get()).forEach(s -> {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null || !DepositUtils.addDefaultMatcher(block)) {
                    Geolosys.getInstance().LOGGER.warn("{} is not a valid block. Please verify.", s);
                }
            });
        }
        return (HashSet)defaultMatchersCached.clone();
    }

    public static boolean addDefaultMatcher(Block block) {
        BlockState defaultState = block.m_49966_();
        if (!defaultState.m_60795_()) {
            defaultMatchersCached.add(defaultState);
            return true;
        }
        return false;
    }

    public static boolean nearlyEquals(float a, float b) {
        return Math.abs(a - b) <= Float.MIN_VALUE;
    }
}

