/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.BiomeDictionary;

public class LayerDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_layer";
    private HashMap<String, HashMap<BlockState, Float>> oreToWtMap = new HashMap();
    private HashMap<BlockState, Float> sampleToWtMap = new HashMap();
    private int yMin;
    private int yMax;
    private int radius;
    private int depth;
    private int genWt;
    private HashSet<BlockState> blockStateMatchers;
    private String[] dimFilter;
    private boolean isDimFilterBl;
    @Nullable
    private List<BiomeDictionary.Type> biomeTypeFilter;
    @Nullable
    private List<Biome> biomeFilter;
    @Nullable
    private boolean isBiomeFilterBl;
    private HashMap<String, Float> cumulOreWtMap = new HashMap();
    private float sumWtSamples = 0.0f;

    public LayerDeposit(HashMap<String, HashMap<BlockState, Float>> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int yMin, int yMax, int radius, int depth, int genWt, String[] dimFilter, boolean isDimFilterBl, @Nullable List<BiomeDictionary.Type> biomeTypes, @Nullable List<Biome> biomeFilter, @Nullable boolean isBiomeFilterBl, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.radius = radius;
        this.depth = depth;
        this.genWt = genWt;
        this.dimFilter = dimFilter;
        this.isDimFilterBl = isDimFilterBl;
        this.biomeTypeFilter = biomeTypes;
        this.isBiomeFilterBl = isBiomeFilterBl;
        this.blockStateMatchers = blockStateMatchers;
        this.biomeFilter = biomeFilter;
        if (!this.oreToWtMap.containsKey("default")) {
            throw new RuntimeException("Pluton blocks should always have a default key");
        }
        for (Map.Entry<String, HashMap<BlockState, Float>> entry : this.oreToWtMap.entrySet()) {
            if (!this.cumulOreWtMap.containsKey(entry.getKey())) {
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(0.0f));
            }
            for (Map.Entry<BlockState, Float> j : entry.getValue().entrySet()) {
                float v = this.cumulOreWtMap.get(entry.getKey()).floatValue();
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(v + j.getValue().floatValue()));
            }
            if (DepositUtils.nearlyEquals(this.cumulOreWtMap.get(entry.getKey()).floatValue(), 1.0f)) continue;
            throw new RuntimeException("Sum of weights for pluton blocks should equal 1.0");
        }
        for (Map.Entry<String, Serializable> entry : this.sampleToWtMap.entrySet()) {
            this.sumWtSamples += ((Float)entry.getValue()).floatValue();
        }
        if (!DepositUtils.nearlyEquals(this.sumWtSamples, 1.0f)) {
            throw new RuntimeException("Sum of weights for pluton samples should equal 1.0");
        }
    }

    @Nullable
    public BlockState getOre(BlockState currentState) {
        String currentStateRegName = Objects.requireNonNull(currentState.m_60734_().getRegistryName()).toString();
        String res = this.oreToWtMap.containsKey(currentStateRegName) ? currentStateRegName : "default";
        return DepositUtils.pick(this.oreToWtMap.get(res), this.cumulOreWtMap.get(res).floatValue());
    }

    @Nullable
    public BlockState getSample() {
        return DepositUtils.pick(this.sampleToWtMap, this.sumWtSamples);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        this.oreToWtMap.values().forEach(x -> x.keySet().forEach(y -> ret.add((BlockState)y)));
        ret.remove(Blocks.f_50016_.m_49966_());
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(Holder<Biome> b) {
        return DepositUtils.canPlaceInBiome(b, this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl);
    }

    @Override
    public boolean hasBiomeRestrictions() {
        return this.biomeFilter != null || this.biomeTypeFilter != null;
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    @Override
    public String[] getDimensionFilter() {
        return this.dimFilter;
    }

    @Override
    public boolean isDimensionFilterBl() {
        return this.isDimFilterBl;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Layer deposit with Blocks=");
        ret.append(this.getAllOres());
        ret.append(", Samples=");
        ret.append(Arrays.toString(this.sampleToWtMap.keySet().toArray()));
        ret.append(", Y Range=[");
        ret.append(this.yMin);
        ret.append(",");
        ret.append(this.yMax);
        ret.append("], Radius=");
        ret.append(this.radius);
        ret.append(", Depth=");
        ret.append(this.depth);
        return ret.toString();
    }

    @Override
    public int generate(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (!DepositUtils.canPlaceInBiome((Holder<Biome>)level.m_204166_(pos), this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl)) {
            return 0;
        }
        int totlPlaced = 0;
        ChunkPos thisChunk = new ChunkPos(pos);
        int x = (thisChunk.m_45604_() + thisChunk.m_45608_()) / 2 - level.m_5822_().nextInt(8) + level.m_5822_().nextInt(16);
        int y = this.yMin + level.m_5822_().nextInt(Math.abs(this.yMax - this.yMin));
        int z = (thisChunk.m_45605_() + thisChunk.m_45609_()) / 2 - level.m_5822_().nextInt(8) + level.m_5822_().nextInt(16);
        int max = Utils.getTopSolidBlock((LevelReader)level, pos).m_123342_();
        if (y > max) {
            y = Math.max(this.yMin, max);
        }
        BlockPos basePos = new BlockPos(x, y, z);
        for (int dX = -this.radius; dX <= this.radius; ++dX) {
            for (int dZ = -this.radius; dZ <= this.radius; ++dZ) {
                for (int dY = 0; dY < this.depth; ++dY) {
                    BlockPos placePos;
                    BlockState current;
                    BlockState tmp;
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)(this.radius * 2) || (tmp = this.getOre(current = level.m_8055_(placePos = basePos.m_142082_(dX, dY, dZ)))) == null || !this.getBlockStateMatchers().contains(current) && !this.oreToWtMap.containsKey(current.m_60734_().getRegistryName().toString()) || !FeatureUtils.enqueueBlockPlacement(level, thisChunk, placePos, tmp, deposits, chunksGenerated)) continue;
                    ++totlPlaced;
                }
            }
        }
        return totlPlaced;
    }

    @Override
    public void afterGen(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        ChunkPos thisChunk = new ChunkPos(pos);
        int maxSampleCnt = Math.min((Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get(), this.radius / (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get() + this.radius % (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get());
        for (int i = 0; i < maxSampleCnt; ++i) {
            BlockPos samplePos;
            BlockState tmp = this.getSample();
            if (tmp == null || (samplePos = SampleUtils.getSamplePosition(level, new ChunkPos(pos))) == null || SampleUtils.inNonWaterFluid(level, samplePos)) continue;
            if (SampleUtils.isInWater(level, samplePos) && tmp.m_61138_((Property)BlockStateProperties.f_61362_)) {
                tmp = (BlockState)tmp.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            }
            FeatureUtils.enqueueBlockPlacement(level, thisChunk, samplePos, tmp, deposits, chunksGenerated);
            FeatureUtils.fixSnowyBlock(level, samplePos);
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static LayerDeposit deserialize(JsonObject json, JsonDeserializationContext ctx) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<BlockState, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int radius = json.get("radius").getAsInt();
            int depth = json.get("depth").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            String[] dimFilter = SerializerUtils.getDimFilter(json);
            boolean isDimFilterBl = SerializerUtils.getIsDimFilterBl(json);
            boolean isBiomeFilterBl = true;
            List<BiomeDictionary.Type> biomeTypeFilter = null;
            List<Biome> biomeFilter = null;
            if (json.has("biomes")) {
                String[] biomeArrRaw = SerializerUtils.getBiomeFilter(json);
                isBiomeFilterBl = SerializerUtils.getIsBiomeFilterBl(json);
                biomeTypeFilter = SerializerUtils.extractBiomeTypes(biomeArrRaw);
                biomeFilter = SerializerUtils.extractBiomes(biomeArrRaw);
            }
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new LayerDeposit(oreBlocks, sampleBlocks, yMin, yMax, radius, depth, genWt, dimFilter, isDimFilterBl, biomeTypeFilter, biomeFilter, isBiomeFilterBl, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize(LayerDeposit dep, JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        JsonParser parser = new JsonParser();
        JsonObject biomes = new JsonObject();
        biomes.addProperty("isBlacklist", Boolean.valueOf(this.isBiomeFilterBl));
        biomes.add("filter", (JsonElement)SerializerUtils.deconstructBiomes(this.biomeFilter, this.biomeTypeFilter));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("isBlacklist", Boolean.valueOf(this.isDimFilterBl));
        dimensions.add("filter", parser.parse(Arrays.toString(this.dimFilter)));
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWtMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("radius", (Number)this.radius);
        config.addProperty("depth", (Number)this.depth);
        config.addProperty("generationWeight", (Number)this.genWt);
        config.add("dimensions", (JsonElement)dimensions);
        config.add("biomes", (JsonElement)biomes);
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

