/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.BiomeDictionary;

public class SparseDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_sparse";
    private HashMap<String, HashMap<BlockState, Float>> oreToWtMap = new HashMap();
    private HashMap<BlockState, Float> sampleToWtMap = new HashMap();
    private int yMin;
    private int yMax;
    private int size;
    private int spread;
    private int genWt;
    private HashSet<BlockState> blockStateMatchers;
    private String[] dimFilter;
    private boolean isDimFilterBl;
    @Nullable
    private List<BiomeDictionary.Type> biomeTypeFilter;
    @Nullable
    private List<Biome> biomeFilter;
    @Nullable
    private boolean isBiomeFilterBl;
    private HashMap<String, Float> cumulOreWtMap = new HashMap();
    private float sumWtSamples = 0.0f;

    public SparseDeposit(HashMap<String, HashMap<BlockState, Float>> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int yMin, int yMax, int size, int spread, int genWt, String[] dimFilter, boolean isDimFilterBl, @Nullable List<BiomeDictionary.Type> biomeTypes, @Nullable List<Biome> biomeFilter, @Nullable boolean isBiomeFilterBl, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.spread = spread;
        this.genWt = genWt;
        this.dimFilter = dimFilter;
        this.isDimFilterBl = isDimFilterBl;
        this.biomeTypeFilter = biomeTypes;
        this.isBiomeFilterBl = isBiomeFilterBl;
        this.blockStateMatchers = blockStateMatchers;
        this.biomeFilter = biomeFilter;
        if (!this.oreToWtMap.containsKey("default")) {
            throw new RuntimeException("Pluton blocks should always have a default key");
        }
        for (Map.Entry<String, HashMap<BlockState, Float>> entry : this.oreToWtMap.entrySet()) {
            if (!this.cumulOreWtMap.containsKey(entry.getKey())) {
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(0.0f));
            }
            for (Map.Entry<BlockState, Float> j : entry.getValue().entrySet()) {
                float v = this.cumulOreWtMap.get(entry.getKey()).floatValue();
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(v + j.getValue().floatValue()));
            }
            if (DepositUtils.nearlyEquals(this.cumulOreWtMap.get(entry.getKey()).floatValue(), 1.0f)) continue;
            throw new RuntimeException("Sum of weights for pluton blocks should equal 1.0");
        }
        for (Map.Entry<String, Serializable> entry : this.sampleToWtMap.entrySet()) {
            this.sumWtSamples += ((Float)entry.getValue()).floatValue();
        }
        if (!DepositUtils.nearlyEquals(this.sumWtSamples, 1.0f)) {
            throw new RuntimeException("Sum of weights for pluton samples should equal 1.0");
        }
    }

    @Nullable
    public BlockState getOre(BlockState currentState) {
        String currentStateRegName = Objects.requireNonNull(currentState.m_60734_().getRegistryName()).toString();
        String res = this.oreToWtMap.containsKey(currentStateRegName) ? currentStateRegName : "default";
        return DepositUtils.pick(this.oreToWtMap.get(res), this.cumulOreWtMap.get(res).floatValue());
    }

    @Nullable
    public BlockState getSample() {
        return DepositUtils.pick(this.sampleToWtMap, this.sumWtSamples);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        this.oreToWtMap.values().forEach(x -> x.keySet().forEach(y -> ret.add((BlockState)y)));
        ret.remove(Blocks.f_50016_.m_49966_());
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(Holder<Biome> b) {
        return DepositUtils.canPlaceInBiome(b, this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl);
    }

    @Override
    public boolean hasBiomeRestrictions() {
        return this.biomeFilter != null || this.biomeTypeFilter != null;
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    @Override
    public String[] getDimensionFilter() {
        return this.dimFilter;
    }

    @Override
    public boolean isDimensionFilterBl() {
        return this.isDimFilterBl;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Sparse deposit with Blocks=");
        ret.append(this.getAllOres());
        ret.append(", Samples=");
        ret.append(Arrays.toString(this.sampleToWtMap.keySet().toArray()));
        ret.append(", Y Range=[");
        ret.append(this.yMin);
        ret.append(",");
        ret.append(this.yMax);
        ret.append("], Size of deposit =");
        ret.append(this.size);
        ret.append(", Spread=");
        ret.append(this.spread);
        return ret.toString();
    }

    @Override
    public int generate(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        int max;
        if (!DepositUtils.canPlaceInBiome((Holder<Biome>)level.m_204166_(pos), this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl)) {
            return 0;
        }
        int totlPlaced = 0;
        int totlPnding = 0;
        ChunkPos thisChunk = new ChunkPos(pos);
        int randY = this.yMin + level.m_5822_().nextInt(this.yMax - this.yMin);
        if (randY > (max = Utils.getTopSolidBlock((LevelReader)level, pos).m_123342_())) {
            randY = Math.max(this.yMin, max);
        }
        float ranFlt = level.m_5822_().nextFloat() * (float)Math.PI;
        double x1 = (float)(pos.m_123341_() + 8) + Mth.m_14031_((float)ranFlt) * (float)this.size / 8.0f;
        double x2 = (float)(pos.m_123341_() + 8) - Mth.m_14031_((float)ranFlt) * (float)this.size / 8.0f;
        double z1 = (float)(pos.m_123343_() + 8) + Mth.m_14089_((float)ranFlt) * (float)this.size / 8.0f;
        double z2 = (float)(pos.m_123343_() + 8) - Mth.m_14089_((float)ranFlt) * (float)this.size / 8.0f;
        double y1 = randY + level.m_5822_().nextInt(3) - 2;
        double y2 = randY + level.m_5822_().nextInt(3) - 2;
        for (int i = 0; i < this.size; ++i) {
            float radScl = (float)i / (float)this.size;
            double xn = x1 + (x2 - x1) * (double)radScl;
            double yn = y1 + (y2 - y1) * (double)radScl;
            double zn = z1 + (z2 - z1) * (double)radScl;
            double noise = level.m_5822_().nextDouble() * (double)this.size / 16.0;
            double radius = (double)(Mth.m_14031_((float)((float)Math.PI * radScl)) + 1.0f) * noise + 1.0;
            int xmin = Mth.m_14107_((double)(xn - radius / 2.0));
            int ymin = Mth.m_14107_((double)(yn - radius / 2.0));
            int zmin = Mth.m_14107_((double)(zn - radius / 2.0));
            int xmax = Mth.m_14107_((double)(xn + radius / 2.0));
            int ymax = Mth.m_14107_((double)(yn + radius / 2.0));
            int zmax = Mth.m_14107_((double)(zn + radius / 2.0));
            for (int x = xmin; x <= xmax; ++x) {
                double layerRadX = ((double)x + 0.5 - xn) / (radius / 2.0);
                if (!(layerRadX * layerRadX < 1.0)) continue;
                for (int y = ymin; y <= ymax; ++y) {
                    double layerRadY = ((double)y + 0.5 - yn) / (radius / 2.0);
                    if (!(layerRadX * layerRadX + layerRadY * layerRadY < 1.0)) continue;
                    for (int z = zmin; z <= zmax; ++z) {
                        int zSpread;
                        int xSpread;
                        BlockPos placePos;
                        BlockState current;
                        BlockState tmp;
                        double layerRadZ = ((double)z + 0.5 - zn) / (radius / 2.0);
                        if (!(layerRadX * layerRadX + layerRadY * layerRadY + layerRadZ * layerRadZ < 1.0) || (tmp = this.getOre(current = level.m_8055_(placePos = new BlockPos(x + (xSpread = level.m_5822_().nextInt(this.spread) * (level.m_5822_().nextBoolean() ? 1 : -1)), y, z + (zSpread = level.m_5822_().nextInt(this.spread) * (level.m_5822_().nextBoolean() ? 1 : -1)))))) == null || !this.getBlockStateMatchers().contains(current) && !this.oreToWtMap.containsKey(current.m_60734_().getRegistryName().toString())) continue;
                        if (FeatureUtils.enqueueBlockPlacement(level, thisChunk, placePos, tmp, deposits, chunksGenerated)) {
                            ++totlPlaced;
                            continue;
                        }
                        ++totlPnding;
                    }
                }
            }
        }
        return totlPlaced + totlPnding;
    }

    @Override
    public void afterGen(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        ChunkPos thisChunk = new ChunkPos(pos);
        int maxSampleCnt = Math.min((Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get(), this.size / (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get() + this.size % (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get()) * (this.spread / 16);
        for (int i = 0; i < maxSampleCnt; ++i) {
            BlockPos samplePos;
            BlockState tmp = this.getSample();
            if (tmp == null || (samplePos = SampleUtils.getSamplePosition(level, new ChunkPos(pos))) == null || SampleUtils.inNonWaterFluid(level, samplePos)) continue;
            if (SampleUtils.isInWater(level, samplePos) && tmp.m_61138_((Property)BlockStateProperties.f_61362_)) {
                tmp = (BlockState)tmp.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            }
            FeatureUtils.enqueueBlockPlacement(level, thisChunk, samplePos, tmp, deposits, chunksGenerated);
            FeatureUtils.fixSnowyBlock(level, samplePos);
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static SparseDeposit deserialize(JsonObject json, JsonDeserializationContext ctx) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<BlockState, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int spread = json.get("spread").getAsInt();
            int size = json.get("size").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            String[] dimFilter = SerializerUtils.getDimFilter(json);
            boolean isDimFilterBl = SerializerUtils.getIsDimFilterBl(json);
            boolean isBiomeFilterBl = true;
            List<BiomeDictionary.Type> biomeTypeFilter = null;
            List<Biome> biomeFilter = null;
            if (json.has("biomes")) {
                String[] biomeArrRaw = SerializerUtils.getBiomeFilter(json);
                isBiomeFilterBl = SerializerUtils.getIsBiomeFilterBl(json);
                biomeTypeFilter = SerializerUtils.extractBiomeTypes(biomeArrRaw);
                biomeFilter = SerializerUtils.extractBiomes(biomeArrRaw);
            }
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new SparseDeposit(oreBlocks, sampleBlocks, yMin, yMax, size, spread, genWt, dimFilter, isDimFilterBl, biomeTypeFilter, biomeFilter, isBiomeFilterBl, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize(SparseDeposit dep, JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        JsonParser parser = new JsonParser();
        JsonObject biomes = new JsonObject();
        biomes.addProperty("isBlacklist", Boolean.valueOf(this.isBiomeFilterBl));
        biomes.add("filter", (JsonElement)SerializerUtils.deconstructBiomes(this.biomeFilter, this.biomeTypeFilter));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("isBlacklist", Boolean.valueOf(this.isDimFilterBl));
        dimensions.add("filter", parser.parse(Arrays.toString(this.dimFilter)));
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWtMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("size", (Number)this.size);
        config.addProperty("spread", (Number)this.spread);
        config.addProperty("generationWeight", (Number)this.genWt);
        config.add("dimensions", (JsonElement)dimensions);
        config.add("biomes", (JsonElement)biomes);
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

