/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.BiomeDictionary;

public class TopLayerDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_top_layer";
    private HashMap<String, HashMap<BlockState, Float>> oreToWtMap = new HashMap();
    private HashMap<BlockState, Float> sampleToWtMap = new HashMap();
    private int radius;
    private int depth;
    private float sampleChance;
    private int genWt;
    private HashSet<BlockState> blockStateMatchers;
    private String[] dimFilter;
    private boolean isDimFilterBl;
    @Nullable
    private List<BiomeDictionary.Type> biomeTypeFilter;
    @Nullable
    private List<Biome> biomeFilter;
    @Nullable
    private boolean isBiomeFilterBl;
    private HashMap<String, Float> cumulOreWtMap = new HashMap();
    private float sumWtSamples = 0.0f;

    public TopLayerDeposit(HashMap<String, HashMap<BlockState, Float>> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int radius, int depth, float sampleChance, int genWt, String[] dimFilter, boolean isDimFilterBl, @Nullable List<BiomeDictionary.Type> biomeTypes, @Nullable List<Biome> biomeFilter, @Nullable boolean isBiomeFilterBl, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.radius = radius;
        this.depth = depth;
        this.sampleChance = sampleChance;
        this.genWt = genWt;
        this.dimFilter = dimFilter;
        this.isDimFilterBl = isDimFilterBl;
        this.biomeTypeFilter = biomeTypes;
        this.isBiomeFilterBl = isBiomeFilterBl;
        this.blockStateMatchers = blockStateMatchers;
        this.biomeFilter = biomeFilter;
        if (!this.oreToWtMap.containsKey("default")) {
            throw new RuntimeException("Pluton blocks should always have a default key");
        }
        for (Map.Entry<String, HashMap<BlockState, Float>> entry : this.oreToWtMap.entrySet()) {
            if (!this.cumulOreWtMap.containsKey(entry.getKey())) {
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(0.0f));
            }
            for (Map.Entry<BlockState, Float> j : entry.getValue().entrySet()) {
                float v = this.cumulOreWtMap.get(entry.getKey()).floatValue();
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(v + j.getValue().floatValue()));
            }
            if (DepositUtils.nearlyEquals(this.cumulOreWtMap.get(entry.getKey()).floatValue(), 1.0f)) continue;
            throw new RuntimeException("Sum of weights for pluton blocks should equal 1.0");
        }
        for (Map.Entry<String, Serializable> entry : this.sampleToWtMap.entrySet()) {
            this.sumWtSamples += ((Float)entry.getValue()).floatValue();
        }
        if (!DepositUtils.nearlyEquals(this.sumWtSamples, 1.0f)) {
            throw new RuntimeException("Sum of weights for pluton samples should equal 1.0");
        }
    }

    @Nullable
    public BlockState getOre(BlockState currentState) {
        String currentStateRegName = Objects.requireNonNull(currentState.m_60734_().getRegistryName()).toString();
        String res = this.oreToWtMap.containsKey(currentStateRegName) ? currentStateRegName : "default";
        return DepositUtils.pick(this.oreToWtMap.get(res), this.cumulOreWtMap.get(res).floatValue());
    }

    @Nullable
    public BlockState getSample() {
        return DepositUtils.pick(this.sampleToWtMap, this.sumWtSamples);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        return null;
    }

    @Override
    public boolean canPlaceInBiome(Holder<Biome> b) {
        return DepositUtils.canPlaceInBiome(b, this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl);
    }

    @Override
    public boolean hasBiomeRestrictions() {
        return this.biomeFilter != null || this.biomeTypeFilter != null;
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    @Override
    public String[] getDimensionFilter() {
        return this.dimFilter;
    }

    @Override
    public boolean isDimensionFilterBl() {
        return this.isDimFilterBl;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Top Layer deposit with Blocks=");
        ret.append(this.getAllOres());
        ret.append(", Samples=");
        ret.append(Arrays.toString(this.sampleToWtMap.keySet().toArray()));
        ret.append(", Radius=");
        ret.append(this.radius);
        ret.append(", Depth=");
        ret.append(this.depth);
        return ret.toString();
    }

    @Override
    public int generate(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (!DepositUtils.canPlaceInBiome((Holder<Biome>)level.m_204166_(pos), this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl)) {
            return 0;
        }
        int totlPlaced = 0;
        ChunkPos thisChunk = new ChunkPos(pos);
        int x = (thisChunk.m_45604_() + thisChunk.m_45608_()) / 2 - level.m_5822_().nextInt(8) + level.m_5822_().nextInt(16);
        int z = (thisChunk.m_45605_() + thisChunk.m_45609_()) / 2 - level.m_5822_().nextInt(8) + level.m_5822_().nextInt(16);
        int radX = this.radius / 2 + level.m_5822_().nextInt(this.radius / 2);
        int radZ = this.radius / 2 + level.m_5822_().nextInt(this.radius / 2);
        BlockPos basePos = new BlockPos(x, 0, z);
        for (int dX = -radX; dX <= radX; ++dX) {
            for (int dZ = -radZ; dZ <= radZ; ++dZ) {
                if (dX * dX + dZ * dZ > this.radius + level.m_5822_().nextInt(Math.max(1, this.radius / 2))) continue;
                BlockPos baseForXZ = Utils.getTopSolidBlock((LevelReader)level, basePos.m_142082_(dX, 0, dZ));
                for (int i = 0; i < this.depth; ++i) {
                    BlockState smpl;
                    boolean isTop;
                    BlockPos placePos = baseForXZ.m_6625_(i);
                    BlockState current = level.m_8055_(placePos);
                    BlockState tmp = this.getOre(current);
                    boolean bl = isTop = i == 0;
                    if (tmp == null) continue;
                    if (tmp.m_61138_((Property)BlockStateProperties.f_61427_)) {
                        tmp = (BlockState)tmp.m_61124_((Property)BlockStateProperties.f_61427_, (Comparable)Boolean.valueOf(!isTop));
                    }
                    if (!this.getBlockStateMatchers().contains(current) && !this.oreToWtMap.containsKey(current.m_60734_().getRegistryName().toString()) || !FeatureUtils.enqueueBlockPlacement(level, thisChunk, placePos, tmp, deposits, chunksGenerated)) continue;
                    ++totlPlaced;
                    if (!isTop || !(level.m_5822_().nextFloat() <= this.sampleChance) || (smpl = this.getSample()) == null) continue;
                    FeatureUtils.enqueueBlockPlacement(level, thisChunk, placePos.m_7494_(), smpl, deposits, chunksGenerated);
                    FeatureUtils.fixSnowyBlock(level, placePos);
                }
            }
        }
        return totlPlaced;
    }

    @Override
    public void afterGen(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static TopLayerDeposit deserialize(JsonObject json, JsonDeserializationContext ctx) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<BlockState, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int radius = json.get("radius").getAsInt();
            int depth = json.get("depth").getAsInt();
            float sampleChance = json.get("chanceForSample").getAsFloat();
            int genWt = json.get("generationWeight").getAsInt();
            String[] dimFilter = SerializerUtils.getDimFilter(json);
            boolean isDimFilterBl = SerializerUtils.getIsDimFilterBl(json);
            boolean isBiomeFilterBl = true;
            List<BiomeDictionary.Type> biomeTypeFilter = null;
            List<Biome> biomeFilter = null;
            if (json.has("biomes")) {
                String[] biomeArrRaw = SerializerUtils.getBiomeFilter(json);
                isBiomeFilterBl = SerializerUtils.getIsBiomeFilterBl(json);
                biomeTypeFilter = SerializerUtils.extractBiomeTypes(biomeArrRaw);
                biomeFilter = SerializerUtils.extractBiomes(biomeArrRaw);
            }
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new TopLayerDeposit(oreBlocks, sampleBlocks, radius, depth, sampleChance, genWt, dimFilter, isDimFilterBl, biomeTypeFilter, biomeFilter, isBiomeFilterBl, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize(TopLayerDeposit dep, JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        JsonParser parser = new JsonParser();
        JsonObject biomes = new JsonObject();
        biomes.addProperty("isBlacklist", Boolean.valueOf(this.isBiomeFilterBl));
        biomes.add("filter", (JsonElement)SerializerUtils.deconstructBiomes(this.biomeFilter, this.biomeTypeFilter));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("isBlacklist", Boolean.valueOf(this.isDimFilterBl));
        dimensions.add("filter", parser.parse(Arrays.toString(this.dimFilter)));
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWtMap));
        config.addProperty("radius", (Number)this.radius);
        config.addProperty("depth", (Number)this.depth);
        config.addProperty("chanceForSample", (Number)Float.valueOf(this.sampleChance));
        config.addProperty("generationWeight", (Number)this.genWt);
        config.add("dimensions", (JsonElement)dimensions);
        config.add("biomes", (JsonElement)biomes);
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

