/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.capability.world;

import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class ChunkGennedCapability
implements IChunkGennedCapability {
    private ConcurrentHashMap.KeySetView<ChunkPos, Boolean> generatedChunks = ConcurrentHashMap.newKeySet();
    public static final Capability<IChunkGennedCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkGennedCapability>(){});

    @Override
    public boolean hasChunkGenerated(ChunkPos pos) {
        return this.generatedChunks.contains(pos);
    }

    @Override
    public void setChunkGenerated(ChunkPos pos) {
        this.generatedChunks.add(pos);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag chunks = new ListTag();
        this.generatedChunks.forEach(chunkPos -> {
            CompoundTag t = new CompoundTag();
            t.m_128405_("x", chunkPos.f_45578_);
            t.m_128405_("z", chunkPos.f_45579_);
            chunks.add((Object)t);
        });
        compound.m_128365_("chunks", (Tag)chunks);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        ListTag chunks = compound.m_128437_("chunks", 10);
        chunks.forEach(x -> {
            CompoundTag comp = (CompoundTag)x;
            ChunkPos chunkPos = new ChunkPos(comp.m_128451_("x"), comp.m_128451_("z"));
            this.generatedChunks.add(chunkPos);
        });
    }
}

