/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import com.oitsjustjose.geolosys.common.config.CommonConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SampleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BlockBehaviour.Properties BASE_PROPS = BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76409_).m_60913_(0.125f, 2.0f).m_60918_(SoundType.f_56739_).m_60988_();

    public SampleBlock() {
        super((Boolean)CommonConfig.SAMPLE_TICK_ENABLED.get() != false ? BASE_PROPS.m_60977_() : BASE_PROPS);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == Blocks.f_49990_) {
            return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
        }
        return this.m_49966_();
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(worldIn, pos);
        return Shapes.m_166049_((double)0.2, (double)0.0, (double)0.2, (double)0.8, (double)0.2, (double)0.8).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
        Random random = new Random();
        if ((int)fallDistance > 0 && random.nextInt((int)fallDistance) > 5) {
            worldIn.m_46961_(pos, true);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_6047_()) {
            worldIn.m_46961_(pos, true);
            player.m_6674_(handIn);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState below = worldIn.m_8055_(pos.m_7495_());
        return below.m_60804_((BlockGetter)worldIn, pos.m_7495_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nonnull
    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)CommonConfig.SAMPLE_TICK_ENABLED.get() != false && state.m_61138_((Property)WATERLOGGED) && ((Boolean)state.m_61143_((Property)WATERLOGGED)).equals(Boolean.FALSE);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        BlockState[] neighbors = new BlockState[]{worldIn.m_8055_(pos.m_142082_(1, 0, 0)), worldIn.m_8055_(pos.m_142082_(-1, 0, 0)), worldIn.m_8055_(pos.m_142082_(0, 0, 1)), worldIn.m_8055_(pos.m_142082_(0, 0, -1))};
        int waterNeighbors = 0;
        for (BlockState b : neighbors) {
            if (b.m_60819_() != Fluids.f_76193_.m_76068_(false)) continue;
            ++waterNeighbors;
        }
        if (waterNeighbors > 1) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 18);
        }
    }
}

