/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.network;

import com.oitsjustjose.geolosys.Geolosys;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class PacketHelpers {
    public static final String BLOCK_NBT_NAME = "blocks";
    public static final String BLOCKPOS_NBT_NAME = "positions";

    public static CompoundTag encodeBlocks(HashSet<BlockState> blocks) {
        CompoundTag comp = new CompoundTag();
        ListTag list = new ListTag();
        for (BlockState b : blocks) {
            list.add((Object)NbtUtils.m_129202_((BlockState)b));
        }
        comp.m_128365_(BLOCK_NBT_NAME, (Tag)list);
        return comp;
    }

    public static HashSet<BlockState> decodeBlocks(CompoundTag comp) {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        ListTag list = comp.m_128437_(BLOCK_NBT_NAME, 10);
        list.forEach(c -> {
            if (c instanceof CompoundTag) {
                ret.add(NbtUtils.m_129241_((CompoundTag)((CompoundTag)c)));
            } else {
                Geolosys.getInstance().LOGGER.error("The following compound appears to be broken: {}", c);
            }
        });
        return ret;
    }

    public static CompoundTag encodeBlockPosns(HashSet<BlockPos> pos) {
        CompoundTag comp = new CompoundTag();
        ListTag list = new ListTag();
        for (BlockPos p : pos) {
            list.add((Object)NbtUtils.m_129224_((BlockPos)p));
        }
        comp.m_128365_(BLOCKPOS_NBT_NAME, (Tag)list);
        return comp;
    }

    public static HashSet<BlockPos> decodeBlockPosns(CompoundTag comp) {
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        ListTag list = comp.m_128437_(BLOCKPOS_NBT_NAME, 10);
        list.forEach(c -> {
            if (c instanceof CompoundTag) {
                ret.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)c)));
            } else {
                Geolosys.getInstance().LOGGER.error("The following compound appears to be broken: {}", c);
            }
        });
        return ret;
    }

    public static String messagify(HashSet<BlockState> blocks) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        for (BlockState b : blocks) {
            sb.append(new ItemStack((ItemLike)b.m_60734_()).m_41611_().getString().replace("[", "").replace("]", ""));
            if (idx + 2 == blocks.size()) {
                sb.append(" & ");
            } else if (idx + 1 != blocks.size()) {
                sb.append(", ");
            }
            ++idx;
        }
        return sb.toString();
    }
}

