/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.GeolosysFeatures;
import com.oitsjustjose.geolosys.common.world.OreRemover;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlutonRegistry {
    private ArrayList<IDeposit> deposits = new ArrayList();
    private static final List<GenerationStep.Decoration> decorations = new LinkedList<GenerationStep.Decoration>();

    public void clear() {
        this.deposits = new ArrayList();
    }

    public ArrayList<IDeposit> getOres() {
        return (ArrayList)this.deposits.clone();
    }

    public boolean addDeposit(IDeposit ore) {
        return this.deposits.add(ore);
    }

    @Nullable
    public IDeposit pick(WorldGenLevel level, BlockPos pos) {
        ArrayList choices = (ArrayList)this.deposits.clone();
        choices.removeIf(dep -> {
            ResourceLocation dim = level.m_6018_().m_46472_().m_135782_();
            boolean isDimFilterBl = dep.isDimensionFilterBl();
            for (String dim2Raw : dep.getDimensionFilter()) {
                boolean match = new ResourceLocation(dim2Raw).equals((Object)dim);
                if ((!isDimFilterBl || !match) && (isDimFilterBl || match)) continue;
                return true;
            }
            return false;
        });
        if (choices.size() == 0) {
            return null;
        }
        if (level.m_5822_().nextInt(3) == 0 && choices.stream().anyMatch(dep -> dep.hasBiomeRestrictions() && dep.canPlaceInBiome((Holder<Biome>)level.m_204166_(pos)))) {
            choices.removeIf(dep -> !dep.hasBiomeRestrictions() || !dep.canPlaceInBiome((Holder<Biome>)level.m_204166_(pos)));
        }
        int totalWt = 0;
        for (IDeposit d : choices) {
            totalWt += d.getGenWt();
        }
        int rng = level.m_5822_().nextInt(totalWt);
        for (IDeposit d : choices) {
            int wt = d.getGenWt();
            if (rng < wt) {
                return d;
            }
            rng -= wt;
        }
        Geolosys.getInstance().LOGGER.error("Could not reach decision on pluton to generate at PlutonRegistry#pick");
        return null;
    }

    @SubscribeEvent
    public void onBiomesLoaded(BiomeLoadingEvent evt) {
        BiomeGenerationSettingsBuilder gen = evt.getGeneration();
        if (((Boolean)CommonConfig.REMOVE_VANILLA_ORES.get()).booleanValue()) {
            for (GenerationStep.Decoration stage : decorations) {
                List feats = gen.getFeatures(stage);
                List<Holder<PlacedFeature>> filtered = OreRemover.filterFeatures(feats);
                Geolosys.getInstance().LOGGER.info("Removing {} Vanilla Ore Entries", (Object)filtered.size());
                for (Holder<PlacedFeature> feature : filtered) {
                    feats.remove(feature);
                }
            }
        }
        gen.m_204201_(GenerationStep.Decoration.RAW_GENERATION, GeolosysFeatures.DEPOSITS_PLACED);
        gen.m_204201_(GenerationStep.Decoration.RAW_GENERATION, GeolosysFeatures.REMOVE_VEINS_PLACED);
    }

    static {
        decorations.add(GenerationStep.Decoration.UNDERGROUND_ORES);
        decorations.add(GenerationStep.Decoration.UNDERGROUND_DECORATION);
    }
}

