/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.capability.deposit.DepositCapability;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.ChunkGennedCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.registries.ObjectHolder;

public class RemoveVeinsFeature
extends Feature<NoneFeatureConfiguration> {
    private final ArrayList<Block> UNACCEPTABLE = Lists.newArrayList((Object[])new Block[]{Blocks.f_152598_, Blocks.f_152599_, Blocks.f_152468_, Blocks.f_152505_});
    @ObjectHolder(value="geolosys:malachite_ore")
    public static final Block geolosysMalachiteOreBlock = null;
    @ObjectHolder(value="geolosys:deepslate_hematite_ore")
    public static final Block geolosysDeepslateHematiteOreBlock = null;
    private final HashMap<Block, Block> oreReplacementMap = this.initOreReplacementMap();

    public RemoveVeinsFeature(Codec<NoneFeatureConfiguration> p_i231976_1_) {
        super(p_i231976_1_);
    }

    private HashMap<Block, Block> initOreReplacementMap() {
        HashMap<Block, Block> map = new HashMap<Block, Block>(){
            {
                this.put(Blocks.f_152505_, geolosysMalachiteOreBlock);
                this.put(Blocks.f_152599_, geolosysMalachiteOreBlock);
                this.put(Blocks.f_152468_, geolosysDeepslateHematiteOreBlock);
                this.put(Blocks.f_152598_, geolosysDeepslateHematiteOreBlock);
            }
        };
        if (((Boolean)CommonConfig.REMOVE_VEIN_ORES.get()).booleanValue()) {
            map.put(Blocks.f_152505_, Blocks.f_50069_);
            map.put(Blocks.f_152599_, Blocks.f_50069_);
            map.put(Blocks.f_152468_, Blocks.f_152550_);
            map.put(Blocks.f_152598_, Blocks.f_152550_);
        }
        return map;
    }

    public final RemoveVeinsFeature withRegistryName(String modID, String name) {
        this.setRegistryName(new ResourceLocation(modID, name));
        return this;
    }

    @ParametersAreNonnullByDefault
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> f) {
        if (f.m_159775_() instanceof FlatLevelSource) {
            return false;
        }
        if (!((Boolean)CommonConfig.REMOVE_VANILLA_ORES.get()).booleanValue()) {
            return true;
        }
        WorldGenLevel level = f.m_159774_();
        ChunkPos cp = new ChunkPos(f.m_159777_());
        IDepositCapability deposits = (IDepositCapability)level.m_6018_().getCapability(DepositCapability.CAPABILITY).orElseThrow(() -> new RuntimeException("Geolosys detected a null Pluton capability somehow. Are any invasive world gen mods active?"));
        IChunkGennedCapability chunks = (IChunkGennedCapability)level.m_6018_().getCapability(ChunkGennedCapability.CAPABILITY).orElseThrow(() -> new RuntimeException("Geolosys detected a null Pluton capability somehow. Are any invasive world gen mods active?"));
        for (int x = cp.m_45604_(); x <= cp.m_45608_(); ++x) {
            for (int z = cp.m_45605_(); z <= cp.m_45609_(); ++z) {
                for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
                    BlockPos p = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(p);
                    if (!this.UNACCEPTABLE.contains(state.m_60734_())) continue;
                    BlockState properReplacement = this.oreReplacementMap.get(state.m_60734_()).m_49966_();
                    FeatureUtils.enqueueBlockPlacement(level, cp, p, properReplacement, deposits, chunks);
                }
            }
        }
        return true;
    }
}

