/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DenseDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_dense";
    private final HashMap<String, HashMap<BlockState, Float>> oreToWtMap;
    private final HashMap<BlockState, Float> sampleToWtMap;
    private final int yMin;
    private final int yMax;
    private final int size;
    private final int genWt;
    private final HashSet<BlockState> blockStateMatchers;
    private final TagKey<Biome> biomeTag;
    private final HashMap<String, Float> cumulOreWtMap = new HashMap();
    private float sumWtSamples = 0.0f;

    public DenseDeposit(HashMap<String, HashMap<BlockState, Float>> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int yMin, int yMax, int size, int genWt, TagKey<Biome> biomeTag, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.genWt = genWt;
        this.biomeTag = biomeTag;
        this.blockStateMatchers = blockStateMatchers;
        if (!this.oreToWtMap.containsKey("default")) {
            throw new RuntimeException("Pluton blocks should always have a default key");
        }
        for (Map.Entry<String, HashMap<BlockState, Float>> entry : this.oreToWtMap.entrySet()) {
            if (!this.cumulOreWtMap.containsKey(entry.getKey())) {
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(0.0f));
            }
            for (Map.Entry<BlockState, Float> j : entry.getValue().entrySet()) {
                float v = this.cumulOreWtMap.get(entry.getKey()).floatValue();
                this.cumulOreWtMap.put(entry.getKey(), Float.valueOf(v + j.getValue().floatValue()));
            }
            if (DepositUtils.nearlyEquals(this.cumulOreWtMap.get(entry.getKey()).floatValue(), 1.0f)) continue;
            throw new RuntimeException("Sum of weights for pluton blocks should equal 1.0");
        }
        for (Map.Entry<String, Serializable> entry : this.sampleToWtMap.entrySet()) {
            this.sumWtSamples += ((Float)entry.getValue()).floatValue();
        }
        if (!DepositUtils.nearlyEquals(this.sumWtSamples, 1.0f)) {
            throw new RuntimeException("Sum of weights for pluton samples should equal 1.0");
        }
    }

    @Nullable
    public BlockState getOre(BlockState currentState, RandomSource rand) {
        String res = this.oreToWtMap.containsKey(Utils.getRegistryName(currentState)) ? Utils.getRegistryName(currentState) : "default";
        return DepositUtils.pick(this.oreToWtMap.get(res), this.cumulOreWtMap.get(res).floatValue(), rand);
    }

    @Nullable
    public BlockState getSample(RandomSource rand) {
        return DepositUtils.pick(this.sampleToWtMap, this.sumWtSamples, rand);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        this.oreToWtMap.values().forEach(x -> ret.addAll(x.keySet()));
        ret.remove(Blocks.f_50016_.m_49966_());
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(Holder<Biome> b) {
        return b.m_203656_(this.biomeTag);
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    public String toString() {
        return "Dense deposit with Blocks=" + this.getAllOres() + ", Samples=" + Arrays.toString(this.sampleToWtMap.keySet().toArray()) + ", Y Range=[" + this.yMin + "," + this.yMax + "], Size=" + this.size;
    }

    @Override
    public int generate(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        int max;
        if (!this.canPlaceInBiome((Holder<Biome>)level.m_204166_(pos))) {
            return 0;
        }
        int totlPlaced = 0;
        int randY = this.yMin + level.m_213780_().m_188503_(this.yMax - this.yMin);
        if (randY > (max = Utils.getTopSolidBlock((LevelReader)level, pos).m_123342_())) {
            randY = Math.max(this.yMin, max);
        }
        float ranFlt = level.m_213780_().m_188501_() * (float)Math.PI;
        double x1 = (float)(pos.m_123341_() + 8) + Mth.m_14031_((float)ranFlt) * (float)this.size / 8.0f;
        double x2 = (float)(pos.m_123341_() + 8) - Mth.m_14031_((float)ranFlt) * (float)this.size / 8.0f;
        double z1 = (float)(pos.m_123343_() + 8) + Mth.m_14089_((float)ranFlt) * (float)this.size / 8.0f;
        double z2 = (float)(pos.m_123343_() + 8) - Mth.m_14089_((float)ranFlt) * (float)this.size / 8.0f;
        double y1 = randY + level.m_213780_().m_188503_(3) - 2;
        double y2 = randY + level.m_213780_().m_188503_(3) - 2;
        for (int i = 0; i < this.size; ++i) {
            float radScl = (float)i / (float)this.size;
            double xn = x1 + (x2 - x1) * (double)radScl;
            double yn = y1 + (y2 - y1) * (double)radScl;
            double zn = z1 + (z2 - z1) * (double)radScl;
            double noise = level.m_213780_().m_188500_() * (double)this.size / 16.0;
            double radius = (double)(Mth.m_14031_((float)((float)Math.PI * radScl)) + 1.0f) * noise + 1.0;
            int xmin = Mth.m_14107_((double)(xn - radius / 2.0));
            int ymin = Mth.m_14107_((double)(yn - radius / 2.0));
            int zmin = Mth.m_14107_((double)(zn - radius / 2.0));
            int xmax = Mth.m_14107_((double)(xn + radius / 2.0));
            int ymax = Mth.m_14107_((double)(yn + radius / 2.0));
            int zmax = Mth.m_14107_((double)(zn + radius / 2.0));
            for (int x = xmin; x <= xmax; ++x) {
                double layerRadX = ((double)x + 0.5 - xn) / (radius / 2.0);
                if (!(layerRadX * layerRadX < 1.0)) continue;
                for (int y = ymin; y <= ymax; ++y) {
                    double layerRadY = ((double)y + 0.5 - yn) / (radius / 2.0);
                    if (!(layerRadX * layerRadX + layerRadY * layerRadY < 1.0)) continue;
                    for (int z = zmin; z <= zmax; ++z) {
                        BlockPos placePos;
                        BlockState current;
                        BlockState tmp;
                        double layerRadZ = ((double)z + 0.5 - zn) / (radius / 2.0);
                        if (!(layerRadX * layerRadX + layerRadY * layerRadY + layerRadZ * layerRadZ < 1.0) || (tmp = this.getOre(current = level.m_8055_(placePos = new BlockPos(x, y, z)), level.m_213780_())) == null || !this.getBlockStateMatchers().contains(current) && !this.oreToWtMap.containsKey(Utils.getRegistryName(current)) || !FeatureUtils.enqueueBlockPlacement(level, new ChunkPos(pos), placePos, tmp, deposits, chunksGenerated)) continue;
                        ++totlPlaced;
                    }
                }
            }
        }
        return totlPlaced;
    }

    @Override
    public void afterGen(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        ChunkPos thisChunk = new ChunkPos(pos);
        int maxSampleCnt = Math.min((Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get(), this.size / (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get() + this.size % (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get());
        for (int i = 0; i < maxSampleCnt; ++i) {
            BlockPos samplePos;
            BlockState tmp = this.getSample(level.m_213780_());
            if (tmp == null || (samplePos = SampleUtils.getSamplePosition(level, new ChunkPos(pos))) == null || SampleUtils.inNonWaterFluid(level, samplePos)) continue;
            if (SampleUtils.isInWater(level, samplePos) && tmp.m_61138_((Property)BlockStateProperties.f_61362_)) {
                tmp = (BlockState)tmp.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE);
            }
            FeatureUtils.enqueueBlockPlacement(level, thisChunk, samplePos, tmp, deposits, chunksGenerated);
            FeatureUtils.fixSnowyBlock(level, samplePos);
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static DenseDeposit deserialize(JsonObject json) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<BlockState, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int size = json.get("size").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            TagKey biomeTag = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(json.get("biomeTag").getAsString().replace("#", "")));
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new DenseDeposit(oreBlocks, sampleBlocks, yMin, yMax, size, genWt, (TagKey<Biome>)biomeTag, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWtMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("size", (Number)this.size);
        config.addProperty("generationWeight", (Number)this.genWt);
        config.addProperty("biomeTag", this.biomeTag.f_203868_().toString());
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

