/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.common.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SerializerUtils {
    @NotNull
    public static BlockState fromString(@Nullable String string) {
        if (string == null) {
            return Blocks.f_50016_.m_49966_();
        }
        ResourceLocation r = new ResourceLocation(string);
        return Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(r)).m_49966_();
    }

    public static String[] toStringArray(JsonArray arr) {
        String[] ret = new String[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            ret[i] = arr.get(i).getAsString();
        }
        return ret;
    }

    public static HashSet<BlockState> toBlockStateList(JsonArray arr) {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        for (String s : SerializerUtils.toStringArray(arr)) {
            ret.add(SerializerUtils.fromString(s));
        }
        return ret;
    }

    public static HashMap<BlockState, Float> buildMultiBlockMap(JsonArray arr) {
        HashMap<BlockState, Float> ret = new HashMap<BlockState, Float>();
        for (JsonElement j : arr) {
            JsonObject pair = j.getAsJsonObject();
            if (pair.get("block").isJsonNull()) {
                ret.put(null, Float.valueOf(pair.get("chance").getAsFloat()));
                continue;
            }
            ret.put(SerializerUtils.fromString(pair.get("block").getAsString()), Float.valueOf(pair.get("chance").getAsFloat()));
        }
        return ret;
    }

    public static JsonArray deconstructMultiBlockMap(HashMap<BlockState, Float> in) {
        JsonArray ret = new JsonArray();
        for (Map.Entry<BlockState, Float> e : in.entrySet()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("block", Utils.getRegistryName(e.getKey().m_60734_()));
            obj.addProperty("chance", (Number)e.getValue());
            ret.add((JsonElement)obj);
        }
        return ret;
    }

    public static HashMap<String, HashMap<BlockState, Float>> buildMultiBlockMatcherMap(JsonObject obj) {
        HashMap<String, HashMap<BlockState, Float>> ret = new HashMap<String, HashMap<BlockState, Float>>();
        obj.keySet().forEach(key -> {
            HashMap<BlockState, Float> value = SerializerUtils.buildMultiBlockMap(obj.get(key).getAsJsonArray());
            ret.put((String)key, value);
        });
        return ret;
    }

    public static JsonObject deconstructMultiBlockMatcherMap(HashMap<String, HashMap<BlockState, Float>> in) {
        JsonObject ret = new JsonObject();
        for (Map.Entry<String, HashMap<BlockState, Float>> i : in.entrySet()) {
            String key = i.getKey();
            JsonArray value = SerializerUtils.deconstructMultiBlockMap(i.getValue());
            ret.add(key, (JsonElement)value);
        }
        return ret;
    }
}

