/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.items;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.utils.GeolosysGroup;
import com.oitsjustjose.geolosys.common.utils.Prospecting;
import com.oitsjustjose.geolosys.common.utils.Utils;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ProPickItem
extends Item {
    public static Item.Properties props = (Boolean)CommonConfig.ENABLE_PRO_PICK_DMG.get() != false ? new Item.Properties().m_41487_(1).m_41491_((CreativeModeTab)GeolosysGroup.getInstance()).m_41503_(((Integer)CommonConfig.PRO_PICK_DURABILITY.get()).intValue()) : new Item.Properties().m_41487_(1).m_41491_((CreativeModeTab)GeolosysGroup.getInstance());

    public ProPickItem() {
        super(props);
        Geolosys.proxy.registerClientSubscribeEvent((Object)this);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        int yStart;
        int xEnd;
        int xStart;
        int zEnd;
        int zStart;
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            return InteractionResult.CONSUME;
        }
        ItemStack stack = player.m_21120_(hand);
        if (worldIn.f_46443_) {
            player.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        if (!player.m_7500_()) {
            stack.m_41622_(1, (LivingEntity)player, x -> x.m_21190_(hand));
        }
        int range = (Integer)CommonConfig.PRO_PICK_RANGE.get();
        int diam = (Integer)CommonConfig.PRO_PICK_DIAMETER.get();
        int n = facing == Direction.NORTH ? 0 : (zStart = facing == Direction.SOUTH ? -range : -(diam / 2));
        int n2 = facing == Direction.NORTH ? range : (zEnd = facing == Direction.SOUTH ? 0 : diam / 2);
        int n3 = facing == Direction.EAST ? -range : (xStart = facing == Direction.WEST ? 0 : -(diam / 2));
        int n4 = facing == Direction.EAST ? 0 : (xEnd = facing == Direction.WEST ? range : diam / 2);
        int n5 = facing == Direction.UP ? -range : (yStart = facing == Direction.DOWN ? 0 : -(diam / 2));
        int yEnd = facing == Direction.UP ? 0 : (facing == Direction.DOWN ? range : diam / 2);
        this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
        player.m_6674_(hand);
        return InteractionResult.CONSUME;
    }

    private void prospect(Player player, ItemStack stack, Level level, BlockPos pos, Direction facing, int xStart, int xEnd, int yStart, int yEnd, int zStart, int zEnd) {
        HashSet<BlockState> foundBlocks = new HashSet<BlockState>();
        HashSet<BlockPos> foundBlockPos = new HashSet<BlockPos>();
        HashSet<BlockState> depositBlocks = Prospecting.getDepositBlocks();
        for (int x = xStart; x <= xEnd; ++x) {
            for (int y = yStart; y <= yEnd; ++y) {
                for (int z = zStart; z <= zEnd; ++z) {
                    BlockPos tmpPos = pos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(tmpPos);
                    if (!depositBlocks.contains(state) || !Prospecting.canDetect(state)) continue;
                    foundBlocks.add(state);
                    foundBlockPos.add(tmpPos);
                }
            }
        }
        if (!foundBlocks.isEmpty()) {
            Geolosys.proxy.sendProspectingMessage(player, foundBlocks, facing.m_122424_());
            foundBlockPos.forEach(_pos -> level.m_5594_(null, _pos, SoundEvents.f_11669_, SoundSource.PLAYERS, 0.15f, 2.0f));
            return;
        }
        this.prospectChunk(level, pos, player);
    }

    private void prospectChunk(Level level, BlockPos pos, Player player) {
        HashSet<BlockState> foundBlocks = new HashSet<BlockState>();
        HashSet<BlockState> depositBlocks = Prospecting.getDepositBlocks();
        ChunkPos tempPos = new ChunkPos(pos);
        for (int x = tempPos.m_45604_(); x <= tempPos.m_45608_(); ++x) {
            for (int z = tempPos.m_45605_(); z <= tempPos.m_45609_(); ++z) {
                for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
                    BlockState state = level.m_8055_(new BlockPos(x, y, z));
                    if (!depositBlocks.contains(state) || !Prospecting.canDetect(state)) continue;
                    foundBlocks.add(state);
                }
            }
        }
        if (!foundBlocks.isEmpty()) {
            Geolosys.proxy.sendProspectingMessage(player, foundBlocks, null);
            return;
        }
        player.m_5661_((Component)Utils.tryTranslate("geolosys.pro_pick.tooltip.nonefound_surface", new Object[0]), true);
    }
}

