/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.common.utils.Constants;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SampleUtils {
    @Nullable
    public static BlockPos getSamplePosition(WorldGenLevel level, ChunkPos chunkPos) {
        return SampleUtils.getSamplePosition(level, chunkPos, -1);
    }

    @Nullable
    public static BlockPos getSamplePosition(WorldGenLevel level, ChunkPos chunkPos, int spread) {
        if (!(level instanceof WorldGenRegion)) {
            return null;
        }
        WorldGenRegion world = (WorldGenRegion)level;
        int usedSpread = Math.max(8, spread);
        int xCenter = (chunkPos.m_45604_() + chunkPos.m_45608_()) / 2;
        int zCenter = (chunkPos.m_45605_() + chunkPos.m_45609_()) / 2;
        int blockPosX = xCenter + level.m_213780_().m_188503_(usedSpread) * (level.m_213780_().m_188499_() ? 1 : -1);
        int blockPosZ = zCenter + level.m_213780_().m_188503_(usedSpread) * (level.m_213780_().m_188499_() ? 1 : -1);
        if (!world.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return null;
        }
        BlockPos searchPos = new BlockPos(blockPosX, world.m_141928_(), blockPosZ);
        while (searchPos.m_123342_() > world.m_141937_()) {
            BlockState blockToPlaceOn = world.m_8055_(searchPos);
            if (Block.m_49918_((VoxelShape)blockToPlaceOn.m_60808_((BlockGetter)world, searchPos), (Direction)Direction.UP)) {
                if (!blockToPlaceOn.m_204336_(Constants.SUPPORTS_SAMPLE)) {
                    searchPos = searchPos.m_7495_();
                    continue;
                }
                BlockPos actualPlacePos = searchPos.m_7494_();
                if (SampleUtils.canReplace((WorldGenLevel)world, actualPlacePos)) {
                    return actualPlacePos;
                }
            }
            searchPos = searchPos.m_7495_();
        }
        return null;
    }

    public static boolean canReplace(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60767_().m_76336_() || state.m_60795_();
    }

    public static boolean isInWater(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() == Blocks.f_49990_;
    }

    public static boolean inNonWaterFluid(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60767_().m_76332_() && !SampleUtils.isInWater(level, pos);
    }

    public static boolean isWithinRange(int posA, int posB, int range) {
        return Math.abs(posA - posB) <= range;
    }
}

