/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.oitsjustjose.geolosys.client.ClientRegistry;
import com.oitsjustjose.geolosys.common.CommonProxy;
import com.oitsjustjose.geolosys.common.blocks.BlockOre;
import com.oitsjustjose.geolosys.common.blocks.BlockOreVanilla;
import com.oitsjustjose.geolosys.common.blocks.BlockSample;
import com.oitsjustjose.geolosys.common.blocks.BlockSampleVanilla;
import com.oitsjustjose.geolosys.common.config.ConfigOres;
import com.oitsjustjose.geolosys.common.config.ConfigParser;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.items.ItemCluster;
import com.oitsjustjose.geolosys.common.items.ItemCoal;
import com.oitsjustjose.geolosys.common.items.ItemCoalCoke;
import com.oitsjustjose.geolosys.common.items.ItemFieldManual;
import com.oitsjustjose.geolosys.common.items.ItemIngot;
import com.oitsjustjose.geolosys.common.items.ItemProPick;
import com.oitsjustjose.geolosys.common.util.Recipes;
import com.oitsjustjose.geolosys.common.world.ChunkData;
import com.oitsjustjose.geolosys.common.world.OreGenerator;
import com.oitsjustjose.geolosys.common.world.StoneGenerator;
import com.oitsjustjose.geolosys.common.world.VanillaWorldGenOverride;
import com.oitsjustjose.geolosys.compat.CompatLoader;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="geolosys", name="Geolosys", version="3.0.9", acceptedMinecraftVersions="1.12", dependencies="after:immersiveengineering@[0.12,);after:contenttweaker;")
public class Geolosys {
    public static final String MODID = "geolosys";
    public static final String VERSION = "3.0.9";
    @SidedProxy(clientSide="com.oitsjustjose.geolosys.client.ClientProxy", serverSide="com.oitsjustjose.geolosys.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="geolosys")
    private static Geolosys instance;
    public Logger LOGGER;
    public ConfigOres configOres;
    public ClientRegistry clientRegistry;
    public ChunkData chunkOreGen;
    public BlockOre ORE;
    public BlockOreVanilla ORE_VANILLA;
    public BlockSample ORE_SAMPLE;
    public BlockSampleVanilla ORE_SAMPLE_VANILLA;
    public Item CLUSTER;
    public Item INGOT;
    public Item COAL;
    public Item COAL_COKE;
    public ItemProPick PRO_PICK;
    public Item ALMANAC;

    public static Geolosys getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        this.LOGGER = event.getModLog();
        this.clientRegistry = new ClientRegistry();
        MinecraftForge.EVENT_BUS.register((Object)this.clientRegistry);
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig.EventHandler());
        this.chunkOreGen = new ChunkData();
        this.ORE = new BlockOre();
        this.ORE_SAMPLE = new BlockSample();
        this.ORE_VANILLA = new BlockOreVanilla();
        this.ORE_SAMPLE_VANILLA = new BlockSampleVanilla();
        this.CLUSTER = new ItemCluster();
        this.ALMANAC = new ItemFieldManual();
        if (ModConfig.featureControl.enableIngots) {
            this.INGOT = new ItemIngot();
        }
        if (ModConfig.featureControl.enableCoals) {
            this.COAL = new ItemCoal();
        }
        if (ModConfig.prospecting.enableProPick) {
            this.PRO_PICK = new ItemProPick();
        }
        if (Loader.isModLoaded((String)"immersiveengineering") && ModConfig.compat.enableIECompat && ModConfig.featureControl.enableCoals) {
            this.COAL_COKE = new ItemCoalCoke();
        }
        this.configOres = new ConfigOres(event.getModConfigurationDirectory());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        MinecraftForge.ORE_GEN_BUS.register((Object)new VanillaWorldGenOverride());
        this.configOres.init();
        ConfigParser.init();
        CompatLoader.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.configOres.postInit();
        if (ModConfig.featureControl.enableSmelting) {
            Recipes.init(this.configOres, this.CLUSTER);
        }
        proxy.postInit(event);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneGenerator(), (int)100);
    }
}

