/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.client;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.api.world.IOre;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.manual.BookChapter;
import com.oitsjustjose.geolosys.common.manual.BookPage;
import com.oitsjustjose.geolosys.common.manual.BookPageContents;
import com.oitsjustjose.geolosys.common.manual.BookPageItemDisplay;
import com.oitsjustjose.geolosys.common.manual.BookPageOre;
import com.oitsjustjose.geolosys.common.manual.BookPageText;
import com.oitsjustjose.geolosys.common.manual.BookPageURL;
import com.oitsjustjose.geolosys.common.manual.ChapterLink;
import com.oitsjustjose.geolosys.common.manual.PatronUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class GuiManual
extends GuiScreen {
    private static final int WIDTH = 146;
    private static final int HEIGHT = 180;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("geolosys", "textures/gui/book.png");
    private static HashMap<String, BookChapter> chapters = new HashMap();
    private String currentChapter = "home";
    private int currentPageNum = 0;
    private BookPage currentPage;
    private String lastChapter;
    private int lastPageNum;
    private ItemStack display = ItemStack.field_190927_a;
    private int left;
    private int top;

    public static void initPages() {
        BookPageContents home = new BookPageContents("geolosys.guide.page.home.name");
        home.addLink(new ChapterLink("geolosys.guide.chapter.introduction.name", "introduction"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.prospecting.name", "prospecting"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.resources.name", "resources"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.mod_compat.name", "mod_compat"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.patrons.name", "patrons"));
        chapters.put("home", new BookChapter("home"));
        chapters.put("introduction", new BookChapter("introduction", "home"));
        chapters.put("prospecting", new BookChapter("prospecting", "home"));
        chapters.put("resources", new BookChapter("resources", "home"));
        chapters.put("mod_compat", new BookChapter("mod_compat", "home"));
        chapters.put("patrons", new BookChapter("patrons", "home"));
        chapters.get("home").addPage(home);
        BookPageContents introduction = new BookPageContents("geolosys.guide.chapter.introduction.name");
        introduction.addLink(new ChapterLink("geolosys.guide.chapter.getting_started.name", "getting_started"));
        introduction.addLink(new ChapterLink("geolosys.guide.chapter.vanilla_ores.name", "vanilla_ores"));
        introduction.addLink(new ChapterLink("geolosys.guide.chapter.modded_ores.name", "modded_ores"));
        chapters.put("getting_started", new BookChapter("getting_started", "introduction"));
        chapters.put("vanilla_ores", new BookChapter("vanilla_ores", "introduction"));
        chapters.put("modded_ores", new BookChapter("modded_ores", "introduction"));
        chapters.get("introduction").addPage(introduction);
        chapters.get("getting_started").addPage(new BookPageText("geolosys.guide.chapter.getting_started.name", "geolosys.guide.chapter.getting_started.text"));
        chapters.get("vanilla_ores").addPage(new BookPageText("geolosys.guide.chapter.vanilla_ores.name", "geolosys.guide.chapter.vanilla_ores.text"));
        chapters.get("modded_ores").addPage(new BookPageText("geolosys.guide.chapter.modded_ores.name", "geolosys.guide.chapter.modded_ores.text"));
        BookPageContents prospecting = new BookPageContents("geolosys.guide.chapter.prospecting.name");
        prospecting.addLink(new ChapterLink("geolosys.guide.chapter.samples.name", "samples"));
        chapters.put("samples", new BookChapter("samples", "prospecting"));
        chapters.get("samples").addPage(new BookPageItemDisplay("geolosys.guide.chapter.samples.name", "geolosys.guide.chapter.samples_1.text", new ItemStack((Block)Geolosys.getInstance().ORE_SAMPLE)));
        chapters.get("samples").addPage(new BookPageItemDisplay("geolosys.guide.chapter.samples.name", "geolosys.guide.chapter.samples_2.text", new ItemStack(Geolosys.getInstance().CLUSTER)));
        if (ModConfig.prospecting.enableProPick) {
            prospecting.addLink(new ChapterLink("geolosys.guide.chapter.propick.name", "propick"));
            chapters.put("propick", new BookChapter("propick", "prospecting"));
            chapters.get("propick").addPage(new BookPageItemDisplay("geolosys.guide.chapter.propick.name", "geolosys.guide.chapter.propick_1.text", new ItemStack((Item)Geolosys.getInstance().PRO_PICK)));
            chapters.get("propick").addPage(new BookPageText("geolosys.guide.chapter.propick.name", "geolosys.guide.chapter.propick_2.text"));
            chapters.get("propick").addPage(new BookPageText("geolosys.guide.chapter.propick.name", "geolosys.guide.chapter.propick_3.text"));
        }
        chapters.get("prospecting").addPage(prospecting);
        ArrayList<BookPageContents> resources = new ArrayList<BookPageContents>();
        resources.add(new BookPageContents("geolosys.guide.chapter.resources.name"));
        int count = 0;
        int page_num = 0;
        if (ModConfig.featureControl.modStones) {
            ((BookPageContents)resources.get(page_num)).addLink(new ChapterLink("geolosys.guide.chapter.stones.name", "stones"));
            chapters.put("stones", new BookChapter("stones", "resources"));
            chapters.get("stones").addPage(new BookPageItemDisplay("geolosys.guide.chapter.stones.name", "geolosys.guide.chapter.stones.text", new ItemStack(Blocks.field_150348_b, 1, new Random().nextInt(3) + 1)));
            if (++count == 12) {
                resources.add(new BookPageContents("geolosys.guide.chapter.resources.name"));
                ++page_num;
                count = 0;
            }
        }
        for (IOre ore : GeolosysAPI.oreBlocks) {
            ((BookPageContents)resources.get(page_num)).addLink(new ChapterLink(ore.getFriendlyName(), ore.getFriendlyName()));
            chapters.put(ore.getFriendlyName(), new BookChapter(ore.getFriendlyName(), "resources"));
            chapters.get(ore.getFriendlyName()).addPage(new BookPageOre(ore));
            if (++count != 12) continue;
            resources.add(new BookPageContents("geolosys.guide.chapter.resources.name"));
            ++page_num;
            count = 0;
        }
        for (BookPageContents contents : resources) {
            chapters.get("resources").addPage(contents);
        }
        BookPageContents modCompat = new BookPageContents("geolosys.guide.chapter.mod_compat.name");
        if (ModConfig.featureControl.retroReplace) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.ore_converter.name", "ore_converter"));
            chapters.put("ore_converter", new BookChapter("ore_converter", "mod_compat"));
            chapters.get("ore_converter").addPage(new BookPageText("geolosys.guide.chapter.ore_converter.name", "geolosys.guide.chapter.ore_converter.text"));
        }
        if (Loader.isModLoaded((String)"journeymap")) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.journeymap.name", "journeymap"));
            chapters.put("journeymap", new BookChapter("journeymap", "mod_compat"));
            chapters.get("journeymap").addPage(new BookPageText("geolosys.guide.chapter.journeymap.name", "geolosys.guide.chapter.journeymap.text"));
        }
        if (Loader.isModLoaded((String)"immersiveengineering") && ModConfig.compat.enableIECompat) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.immersive_engineering.name", "immersive_engineering"));
            chapters.put("immersive_engineering", new BookChapter("immersive_engineering", "mod_compat"));
            chapters.get("immersive_engineering").addPage(new BookPageItemDisplay("geolosys.guide.chapter.immersive_engineering.name", "geolosys.guide.chapter.immersive_engineering.text", (ItemStack)OreDictionary.getOres((String)"dustSulfur").get(0)));
        }
        if (Loader.isModLoaded((String)"betterwithmods")) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.better_with_mods.name", "better_with_mods"));
            chapters.put("better_with_mods", new BookChapter("better_with_mods", "mod_compat"));
            chapters.get("better_with_mods").addPage(new BookPageItemDisplay("geolosys.guide.chapter.better_with_mods.name", "geolosys.guide.chapter.better_with_mods.text", new ItemStack(Items.field_191525_da)));
        }
        if (Loader.isModLoaded((String)"twilightforest")) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.twilight_forest.name", "twilight_forest"));
            chapters.put("twilight_forest", new BookChapter("twilight_forest", "mod_compat"));
            chapters.get("twilight_forest").addPage(new BookPageText("geolosys.guide.chapter.twilight_forest.name", "geolosys.guide.chapter.twilight_forest.text"));
        }
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", "material")) != null) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.applied_energistics.name", "applied_energistics"));
            chapters.put("applied_energistics", new BookChapter("applied_energistics", "mod_compat"));
            chapters.get("applied_energistics").addPage(new BookPageItemDisplay("geolosys.guide.chapter.applied_energistics.name", "geolosys.guide.chapter.applied_energistics.text", new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", "material"))), 1, 0)));
        }
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation("extrautils2", "ingredients")) != null) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.extra_utils.name", "extra_utils"));
            chapters.put("extra_utils", new BookChapter("extra_utils", "mod_compat"));
            chapters.get("extra_utils").addPage(new BookPageItemDisplay("geolosys.guide.chapter.extra_utils.name", "geolosys.guide.chapter.extra_utils.text", new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("extrautils2", "ingredients"))))));
        }
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation("actuallyadditions", "item_misc")) != null) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.actually_additions.name", "actually_additions"));
            chapters.put("actually_additions", new BookChapter("actually_additions", "mod_compat"));
            chapters.get("actually_additions").addPage(new BookPageItemDisplay("geolosys.guide.chapter.actually_additions.name", "geolosys.guide.chapter.actually_additions.text", new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("actuallyadditions", "item_misc"))), 1, 5)));
        }
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermalfoundation", "material")) != null) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.cofh_mods.name", "cofh_mods"));
            chapters.put("cofh_mods", new BookChapter("cofh_mods", "mod_compat"));
            chapters.get("cofh_mods").addPage(new BookPageItemDisplay("geolosys.guide.chapter.cofh_mods.name", "geolosys.guide.chapter.cofh_mods.text", new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermalfoundation", "material"))), 1, 866)));
        }
        if (ModConfig.compat.enableOsmium) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.mekanism.name", "mekanism"));
            chapters.put("mekanism", new BookChapter("mekanism", "mod_compat"));
            chapters.get("mekanism").addPage(new BookPageItemDisplay("geolosys.guide.chapter.mekanism.name", "geolosys.guide.chapter.mekanism.text", new ItemStack(Geolosys.getInstance().CLUSTER, 1, 12)));
        }
        if (ModConfig.compat.enableYellorium) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.extreme_reactors.name", "extreme_reactors"));
            chapters.put("extreme_reactors", new BookChapter("extreme_reactors", "mod_compat"));
            chapters.get("extreme_reactors").addPage(new BookPageItemDisplay("geolosys.guide.chapter.extreme_reactors.name", "geolosys.guide.chapter.extreme_reactors.text", new ItemStack(Geolosys.getInstance().CLUSTER, 1, 11)));
        }
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation("nuclearcraft", "gem")) != null) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.nuclearcraft.name", "nuclearcraft"));
            chapters.put("nuclearcraft", new BookChapter("nuclearcraft", "mod_compat"));
            chapters.get("nuclearcraft").addPage(new BookPageItemDisplay("geolosys.guide.chapter.nuclearcraft.name", "geolosys.guide.chapter.nuclearcraft.text", new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("nuclearcraft", "gem"))), 1, 0)));
        }
        chapters.get("mod_compat").addPage(modCompat);
        ArrayList<BookPage> patrons = new ArrayList<BookPage>();
        ArrayList<String> patronNames = PatronUtil.getInstance().getPatrons();
        if (patronNames.size() == 0) {
            patrons.add(new BookPageURL("geolosys.guide.chapter.patrons.name", "geolosys.guide.chapter.patrons.none.text", "https://patreon.com/oitsjustjose", "geolosys.guide.chapter.patrons.link"));
        } else {
            patrons.add(new BookPageURL("geolosys.guide.chapter.patrons.name", "geolosys.guide.chapter.patrons.desc.text", "https://patreon.com/oitsjustjose", "geolosys.guide.chapter.patrons.link"));
            count = 0;
            page_num = 0;
            int total = 0;
            StringBuilder pageText = new StringBuilder();
            for (String patronName : patronNames) {
                pageText.append("\u2022 " + patronName);
                if (count == 12 || ++total == patronNames.size()) {
                    patrons.add(new BookPageText("geolosys.guide.chapter.patrons.name", pageText.toString()));
                    pageText = new StringBuilder();
                    count = 0;
                    ++page_num;
                    continue;
                }
                pageText.append("<br>");
                ++count;
            }
        }
        for (BookPage page : patrons) {
            chapters.get("patrons").addPage(page);
        }
        for (BookChapter chapter : chapters.values()) {
            if (chapter.getPageCount() > 0) continue;
            chapter.addPage(new BookPage(chapter.getName()));
        }
    }

    public void func_73866_w_() {
        this.top = (this.field_146295_m - 180) / 2;
        this.left = (this.field_146294_l - 146) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(BACKGROUND);
        this.func_73729_b(this.left, this.top, 0, 0, 146, 180);
        if (this.currentPage != null) {
            float textScale;
            String header = TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + I18n.func_135052_a((String)this.currentPage.getTitle(), (Object[])new Object[0]);
            List parts = this.field_146289_q.func_78271_c(header, (int)(110.0f / (textScale = ModConfig.client.manualFontScale)));
            if (parts.size() > 1) {
                int topToDraw = this.top - 12 * parts.size();
                for (String str : parts) {
                    int width = this.field_146289_q.func_78256_a(str);
                    this.field_146289_q.func_78276_b(str, this.left + (146 - width) / 2, topToDraw, 0x777777);
                    topToDraw += 12;
                }
            } else {
                int headerWidth = this.field_146289_q.func_78256_a(header);
                this.field_146289_q.func_78276_b(header, this.left + (146 - headerWidth) / 2, this.top + 12, 0);
            }
            if (this.currentPage instanceof BookPageItemDisplay) {
                this.renderItemDisplayPage((BookPageItemDisplay)this.currentPage, mouseX, mouseY);
            } else if (this.currentPage instanceof BookPageText) {
                this.renderTextPage((BookPageText)this.currentPage);
            } else if (this.currentPage instanceof BookPageOre) {
                this.renderOrePage((BookPageOre)this.currentPage, mouseX, mouseY);
            } else if (this.currentPage instanceof BookPageURL) {
                this.renderURLPage((BookPageURL)this.currentPage, mouseX, mouseY, partialTicks);
            }
            if (chapters.get(this.currentChapter).getPageCount() > 1) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
                String pageNum = this.currentPageNum + 1 + "/" + chapters.get(this.currentChapter).getPageCount();
                int pageNumWidth = (int)((float)this.field_146289_q.func_78256_a(pageNum) * textScale);
                int x = (int)((float)(this.left + (146 - pageNumWidth) / 2) / textScale);
                this.field_146289_q.func_78279_b(pageNum, x, (int)((float)(this.top + 164) / textScale), (int)(110.0f / textScale), 0);
                GlStateManager.func_179121_F();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void renderItemDisplayPage(BookPageItemDisplay page, int mouseX, int mouseY) {
        ItemStack stack = page.getDisplayStack();
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            stack = new ItemStack(stack.func_77973_b(), 1, 0, stack.func_77978_p());
        }
        if (stack.func_77973_b() != this.display.func_77973_b() || stack.func_77960_j() != this.display.func_77960_j()) {
            this.display = stack;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        RenderHelper.func_74520_c();
        int itemX = this.left + 57;
        int itemY = this.top + 24;
        float itemScale = 2.0f;
        this.field_146296_j.func_180450_b(this.display, (int)((float)itemX / itemScale), (int)((float)itemY / itemScale));
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        float textScale = ModConfig.client.manualFontScale;
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)page.getDescription(), (Object[])new Object[0]), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + 58) / textScale), (int)(110.0f / textScale), 0);
        GlStateManager.func_179121_F();
        this.renderTooltip(mouseX, mouseY, itemX, itemY, itemScale);
    }

    private void renderURLPage(BookPageURL page, int mouseX, int mouseY, float partialTicks) {
        int i;
        GlStateManager.func_179094_E();
        float textScale = ModConfig.client.manualFontScale;
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        String text = I18n.func_135052_a((String)page.getText(), (Object[])new Object[0]);
        ArrayList<String> paragraphs = new ArrayList<String>();
        int numOccurences = 0;
        while (text.contains("|")) {
            i = text.indexOf("|");
            paragraphs.add("    " + text.substring(0, i));
            if (i < text.length() - 1) {
                text = text.substring(i + 1);
            }
            ++numOccurences;
        }
        paragraphs.add((numOccurences > 0 ? "    " : "") + text);
        i = 24;
        for (String par : paragraphs) {
            this.field_146289_q.func_78279_b(par, (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), (int)(110.0f / textScale), 0);
            i += (int)(2.0f + (float)this.field_146289_q.func_78267_b(par, (int)(110.0f / textScale)) * textScale);
        }
        GlStateManager.func_179121_F();
    }

    private void renderOrePage(BookPageOre page, int mouseX, int mouseY) {
        ItemStack stack = page.getDisplayStack();
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            stack = new ItemStack(stack.func_77973_b(), 1, 0, stack.func_77978_p());
        }
        if (stack.func_77973_b() != this.display.func_77973_b() || stack.func_77960_j() != this.display.func_77960_j()) {
            this.display = stack;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        RenderHelper.func_74520_c();
        int itemX = this.left + 57;
        int itemY = this.top + 24;
        float itemScale = 2.0f;
        this.field_146296_j.func_180450_b(this.display, (int)((float)itemX / itemScale), (int)((float)itemY / itemScale));
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        float textScale = ModConfig.client.manualFontScale;
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        String minDepthFromSeaLevel = this.getFormattedSeaLevel(Minecraft.func_71410_x().field_71441_e.func_181545_F() - page.getMinY());
        String maxDepthFromSeaLevel = this.getFormattedSeaLevel(Minecraft.func_71410_x().field_71441_e.func_181545_F() - page.getMaxY());
        String description = page.isBiomeRestricted() && page.isMultiOre() ? I18n.func_135052_a((String)"geolosys.guide.chapter.ore.mutli.biome.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getBiomes(), page.getChance(), page.getSize(), page.getHarvestLevel()}) : (page.isMultiOre() ? I18n.func_135052_a((String)"geolosys.guide.chapter.ore.multi.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getChance(), page.getSize(), page.getHarvestLevel()}) : (page.isBiomeRestricted() ? I18n.func_135052_a((String)"geolosys.guide.chapter.ore.biome.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getBiomes(), page.getChance(), page.getSize(), page.getHarvestLevel()}) : I18n.func_135052_a((String)"geolosys.guide.chapter.ore.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getChance(), page.getSize(), page.getHarvestLevel()})));
        this.field_146289_q.func_78279_b(description, (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + 58) / textScale), (int)(110.0f / textScale), 0);
        GlStateManager.func_179121_F();
        this.renderTooltip(mouseX, mouseY, itemX, itemY, itemScale);
    }

    private String getFormattedSeaLevel(int depth) {
        if (depth > 0) {
            return I18n.func_135052_a((String)"geolosys.guide.generic.belowsealevel", (Object[])new Object[]{Math.abs(depth)});
        }
        if (depth < 0) {
            return I18n.func_135052_a((String)"geolosys.guide.generic.abovesealevel", (Object[])new Object[]{Math.abs(depth)});
        }
        return I18n.func_135052_a((String)"geolosys.guide.generic.atsealevel", (Object[])new Object[0]);
    }

    private void renderTooltip(int mouseX, int mouseY, int itemX, int itemY, float itemScale) {
        if (mouseX >= itemX && mouseY >= itemY && (float)mouseX <= (float)itemX + 16.0f * itemScale && (float)mouseY <= (float)itemY + 16.0f * itemScale) {
            GlStateManager.func_179094_E();
            float toolTipScale = 0.85f;
            GlStateManager.func_179152_a((float)toolTipScale, (float)toolTipScale, (float)toolTipScale);
            this.func_146285_a(this.display, (int)((float)mouseX / toolTipScale), (int)((float)mouseY / toolTipScale));
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }

    private void renderTextPage(BookPageText page) {
        int i;
        GlStateManager.func_179094_E();
        float textScale = ModConfig.client.manualFontScale;
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        String text = I18n.func_135052_a((String)page.getText(), (Object[])new Object[0]);
        ArrayList<String> paragraphs = new ArrayList<String>();
        while (text.contains("|") || text.contains("<br>")) {
            i = text.indexOf("|");
            int j = text.indexOf("<br>");
            if (i == -1) {
                paragraphs.add(text.substring(0, j));
                if (j >= text.length() - 1) continue;
                text = text.substring(j + 4);
                continue;
            }
            if (j == -1) {
                paragraphs.add("    " + text.substring(0, i));
                if (i >= text.length() - 1) continue;
                text = text.substring(i + 1);
                continue;
            }
            if (i < j) {
                paragraphs.add("    " + text.substring(0, i));
                if (i >= text.length() - 1) continue;
                text = text.substring(i + 1);
                continue;
            }
            paragraphs.add(text.substring(0, j));
            if (j >= text.length() - 1) continue;
            text = text.substring(j + 4);
        }
        paragraphs.add(text);
        i = 24;
        for (String par : paragraphs) {
            this.field_146289_q.func_78279_b(par, (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), (int)(110.0f / textScale), 0);
            i += (int)(2.0f + (float)this.field_146289_q.func_78267_b(par, (int)(110.0f / textScale)) * textScale);
        }
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.currentPage = chapters.get(this.currentChapter).getPage(this.currentPageNum);
        if (this.currentPageNum != this.lastPageNum || !this.currentChapter.equals(this.lastChapter)) {
            this.resetPage();
        }
        this.lastChapter = this.currentChapter;
        this.lastPageNum = this.currentPageNum;
    }

    private void resetPage() {
        this.field_146292_n.clear();
        int i = 0;
        if (this.currentPage instanceof BookPageContents) {
            List<ChapterLink> links = ((BookPageContents)this.currentPage).getLinks();
            for (ChapterLink link : links) {
                this.func_189646_b(new ChapterLinkButton(i, this.left + 16, this.top + 24 + i * 12, link.text, link.chapter));
                ++i;
            }
        } else if (this.currentPage instanceof BookPageURL) {
            GuiButtonURL urlButton = new GuiButtonURL(this.left, this.top + 180, 146, 20, I18n.func_135052_a((String)((BookPageURL)this.currentPage).getButtonText(), (Object[])new Object[0]), ((BookPageURL)this.currentPage).getURL());
            this.func_189646_b(urlButton);
        }
        if (this.currentPageNum < chapters.get(this.currentChapter).getPageCount() - 1) {
            this.func_189646_b(new PageTurnButton(i, this.left + 100, this.top + 154, true));
            ++i;
        }
        if (this.currentPageNum > 0) {
            this.func_189646_b(new PageTurnButton(i, this.left + 18, this.top + 154, false));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ChapterLinkButton) {
            this.currentChapter = ((ChapterLinkButton)button).getChapter();
            this.currentPageNum = 0;
        } else if (button instanceof PageTurnButton) {
            this.currentPageNum = ((PageTurnButton)button).isForward() ? ++this.currentPageNum : --this.currentPageNum;
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() == par2) {
            if (this.currentChapter.equals(chapters.get(this.currentChapter).getParent())) {
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            } else {
                this.currentChapter = chapters.get(this.currentChapter).getParent();
                this.currentPageNum = 0;
            }
        } else if (1 == par2) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            this.currentChapter = chapters.get(this.currentChapter).getParent();
            this.currentPageNum = 0;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_175273_b(@Nonnull Minecraft mc, int w, int h) {
        this.func_146280_a(mc, w, h);
        this.resetPage();
    }

    @SideOnly(value=Side.CLIENT)
    public class PageTurnButton
    extends GuiButton {
        private final boolean isForward;

        PageTurnButton(int buttonId, int x, int y, boolean isForward) {
            super(buttonId, x, y, 23, 13, "");
            this.isForward = isForward;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BACKGROUND);
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                if (!this.isForward) {
                    j += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 23, 13);
            }
        }

        boolean isForward() {
            return this.isForward;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ChapterLinkButton
    extends GuiButton {
        private String chapter;

        public ChapterLinkButton(int buttonId, int x, int y, String buttonText, String chapter) {
            super(buttonId, x, y, Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)buttonText, (Object[])new Object[0])), Minecraft.func_71410_x().field_71466_p.field_78288_b, buttonText);
            this.chapter = chapter;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                this.func_146119_b(mc, mouseX, mouseY);
                int j = 0;
                String p = "";
                if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 8308926;
                    p = p + TextFormatting.UNDERLINE;
                }
                String toDraw = I18n.func_135052_a((String)this.field_146126_j, (Object[])new Object[0]);
                if (fontrenderer.func_78256_a(p + "\u2022 " + toDraw) > (int)(110.0f / ModConfig.client.manualFontScale)) {
                    toDraw = GuiManual.this.field_146289_q.func_78269_a(toDraw, (int)(110.0f / ModConfig.client.manualFontScale));
                    toDraw = toDraw.substring(0, toDraw.length() - 7);
                    toDraw = toDraw + "...";
                }
                fontrenderer.func_78279_b(p + "\u2022 " + toDraw, this.field_146128_h, this.field_146129_i, (int)(110.0f / ModConfig.client.manualFontScale), j);
            }
        }

        String getChapter() {
            return this.chapter;
        }
    }

    private class GuiButtonURL
    extends GuiButton {
        private String url;

        public GuiButtonURL(int x, int y, int widthIn, int heightIn, String buttonText, String url) {
            super(42069, x, y, widthIn, heightIn, buttonText);
            this.url = url;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(field_146122_a);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(mc, mouseX, mouseY);
                int j = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    j = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            boolean clicked = super.func_146116_c(mc, mouseX, mouseY);
            if (clicked) {
                try {
                    Desktop.getDesktop().browse(URI.create(this.url));
                }
                catch (IOException | NullPointerException | UnsupportedOperationException e) {
                    Geolosys.getInstance().LOGGER.error("Opening the url " + this.url + " failed.");
                }
            }
            return clicked;
        }
    }
}

