/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.api;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.world.Deposit;
import com.oitsjustjose.geolosys.common.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.common.api.world.DepositMultiOre;
import com.oitsjustjose.geolosys.common.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.common.api.world.DepositStone;
import com.oitsjustjose.geolosys.common.api.world.IOre;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.world.OreGenerator;
import com.oitsjustjose.geolosys.common.world.StoneGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class GeolosysAPI {
    public static ArrayList<IOre> oreBlocks = new ArrayList();
    public static ArrayList<IBlockState> proPickExtras = new ArrayList();
    public static ArrayList<IBlockState> replacementMats = new ArrayList();
    public static ArrayList<IBlockState> oreConverterBlacklist = new ArrayList();
    private static HashMap<ChunkPosSerializable, String> currentWorldDeposits = new HashMap();
    private static LinkedHashMap<ChunkPosSerializable, Boolean> regennedChunks = new LinkedHashMap();
    public static ArrayList<DepositStone> stones = new ArrayList();

    public static void putWorldDeposit(ChunkPos pos, int dimension, String state) {
        currentWorldDeposits.put(new ChunkPosSerializable(pos, dimension), state);
        if (ModConfig.featureControl.debugGeneration) {
            int total = 0;
            for (ChunkPosSerializable chunk : currentWorldDeposits.keySet()) {
                if (!currentWorldDeposits.get(chunk).equals(state)) continue;
                ++total;
            }
            Geolosys.getInstance().LOGGER.info(state + ": " + total + "/" + currentWorldDeposits.keySet().size());
            Geolosys.getInstance().LOGGER.info(state + ": " + 100.0f * ((float)total / (1.0f * (float)currentWorldDeposits.keySet().size())) + "%");
        }
    }

    public static void putWorldDeposit(ChunkPosSerializable pos, String state) {
        currentWorldDeposits.put(pos, state);
    }

    public static void putWorldDeposit(String posAsString, String state) {
        String[] parts = posAsString.replace("[", "").replace("]", "").split(",");
        currentWorldDeposits.put(new ChunkPosSerializable(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])), state);
    }

    public static HashMap<ChunkPosSerializable, String> getCurrentWorldDeposits() {
        return (HashMap)currentWorldDeposits.clone();
    }

    public static HashMap<ChunkPosSerializable, Boolean> getRegennedChunks() {
        return (HashMap)regennedChunks.clone();
    }

    public static void markChunkRegenned(String posAsString) {
        String[] parts = posAsString.replace("[", "").replace("]", "").split(",");
        GeolosysAPI.markChunkRegenned(new ChunkPosSerializable(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
    }

    public static void markChunkRegenned(ChunkPos pos, int dimension) {
        GeolosysAPI.markChunkRegenned(new ChunkPosSerializable(pos, dimension));
    }

    public static void markChunkRegenned(ChunkPosSerializable pos) {
        regennedChunks.put(pos, true);
    }

    public static boolean hasChunkRegenned(ChunkPos pos, int dimension) {
        return GeolosysAPI.hasChunkRegenned(new ChunkPosSerializable(pos, dimension));
    }

    public static boolean hasChunkRegenned(ChunkPosSerializable pos) {
        for (ChunkPosSerializable c : regennedChunks.keySet()) {
            if (c.getX() != pos.getX() || c.getZ() != pos.getZ() || c.getDimension() != pos.getDimension()) continue;
            return regennedChunks.get(c);
        }
        return false;
    }

    public static void registerMineralDeposit(IBlockState oreBlock, IBlockState sampleBlock, int yMin, int yMax, int size, int chance, int[] dimBlacklist, List<IBlockState> blockStateMatchers, float density) {
        Deposit tempDeposit = new Deposit(oreBlock, sampleBlock, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers, density);
        OreGenerator.addOreGen(tempDeposit);
        oreBlocks.add(tempDeposit);
    }

    public static void registerMineralDeposit(HashMap<IBlockState, Integer> oreBlockMap, HashMap<IBlockState, Integer> sampleBlockMap, int yMin, int yMax, int size, int chance, int[] dimBlacklist, List<IBlockState> blockStateMatchers, float density) {
        DepositMultiOre tempDeposit = new DepositMultiOre(oreBlockMap, sampleBlockMap, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers, density);
        OreGenerator.addOreGen(tempDeposit);
        oreBlocks.add(tempDeposit);
    }

    public static void registerMineralDeposit(IBlockState oreBlock, IBlockState sampleBlock, int yMin, int yMax, int size, int chance, int[] dimBlacklist, List<IBlockState> blockStateMatchers, List<Biome> biomeList, List<BiomeDictionary.Type> biomeTypes, boolean isWhitelist, float density) {
        DepositBiomeRestricted tempDeposit = new DepositBiomeRestricted(oreBlock, sampleBlock, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers, biomeList, biomeTypes, isWhitelist, density);
        OreGenerator.addOreGen(tempDeposit);
        oreBlocks.add(tempDeposit);
    }

    public static void registerMineralDeposit(HashMap<IBlockState, Integer> oreBlockMap, HashMap<IBlockState, Integer> sampleBlockMap, int yMin, int yMax, int size, int chance, int[] dimBlacklist, List<IBlockState> blockStateMatchers, List<Biome> biomeList, List<BiomeDictionary.Type> biomeTypes, boolean isWhitelist, float density) {
        DepositMultiOreBiomeRestricted tempDeposit = new DepositMultiOreBiomeRestricted(oreBlockMap, sampleBlockMap, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers, biomeList, biomeTypes, isWhitelist, density);
        OreGenerator.addOreGen(tempDeposit);
        oreBlocks.add(tempDeposit);
    }

    public static void registerStoneDeposit(IBlockState stoneBlock, int yMin, int yMax, int chance, int size, int[] dimBlacklist) {
        DepositStone tempDeposit = new DepositStone(stoneBlock, yMin, yMax, chance, size, dimBlacklist);
        StoneGenerator.addStoneGen(tempDeposit);
        stones.add(tempDeposit);
    }

    public static LinkedHashMap<ChunkPosSerializable, Boolean> getRegennedChunks(File file) {
        LinkedHashMap regennedChunksDeprecated = new LinkedHashMap();
        try {
            FileInputStream fileInRegen = new FileInputStream(file);
            ObjectInputStream inRegen = new ObjectInputStream(fileInRegen);
            regennedChunksDeprecated = (LinkedHashMap)inRegen.readObject();
            inRegen.close();
            fileInRegen.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return regennedChunksDeprecated;
    }

    public static HashMap<ChunkPosSerializable, String> getDeposits(File file) {
        HashMap currentWorldDepositsDeprecated = new HashMap();
        try {
            FileInputStream fileInDeposits = new FileInputStream(file);
            ObjectInputStream inDeposits = new ObjectInputStream(fileInDeposits);
            currentWorldDepositsDeprecated = (HashMap)inDeposits.readObject();
            inDeposits.close();
            fileInDeposits.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return currentWorldDepositsDeprecated;
    }

    public static class ChunkPosSerializable
    implements Serializable {
        private static final long serialVersionUID = 6006452707959877895L;
        private int x;
        private int z;
        private int dim;

        public ChunkPosSerializable(ChunkPos pos, int dim) {
            this(pos.field_77276_a, pos.field_77275_b, dim);
        }

        public ChunkPosSerializable(int x, int z, int dim) {
            this.x = x;
            this.z = z;
            this.dim = dim;
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public int getDimension() {
            return this.dim;
        }

        public ChunkPos toChunkPos() {
            return new ChunkPos(this.x, this.z);
        }

        public String toString() {
            return "[" + this.getX() + "," + this.getZ() + "," + this.getDimension() + "]";
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ChunkPosSerializable) {
                ChunkPosSerializable c = (ChunkPosSerializable)other;
                return c.getX() == this.getX() && c.getZ() == this.getZ() && c.getDimension() == this.getDimension();
            }
            return false;
        }
    }
}

