/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.api.world;

import com.oitsjustjose.geolosys.common.api.world.IOre;
import com.oitsjustjose.geolosys.common.util.Utils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class Deposit
implements IOre {
    private IBlockState oreBlock;
    private IBlockState sampleBlock;
    private int yMin;
    private int yMax;
    private int size;
    private int chance;
    private int[] dimensionBlacklist;
    private List<IBlockState> blockStateMatchers;
    private float density;

    public Deposit(IBlockState oreBlock, IBlockState sampleBlock, int yMin, int yMax, int size, int chance, int[] dimensionBlacklist, List<IBlockState> blockStateMatchers, float density) {
        this.oreBlock = oreBlock;
        this.sampleBlock = sampleBlock;
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.chance = chance;
        this.dimensionBlacklist = dimensionBlacklist;
        this.blockStateMatchers = blockStateMatchers;
        this.density = density;
    }

    @Override
    public IBlockState getOre() {
        return this.oreBlock;
    }

    @Override
    public IBlockState getSample() {
        return this.sampleBlock;
    }

    @Override
    public String getFriendlyName() {
        return new ItemStack(this.oreBlock.func_177230_c(), 1, this.oreBlock.func_177230_c().func_176201_c(this.oreBlock)).func_82833_r();
    }

    @Override
    public int getYMin() {
        return this.yMin;
    }

    @Override
    public int getYMax() {
        return this.yMax;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int[] getDimensionBlacklist() {
        return this.dimensionBlacklist;
    }

    @Override
    public boolean canReplace(IBlockState state) {
        if (this.blockStateMatchers == null) {
            return true;
        }
        for (IBlockState s : this.blockStateMatchers) {
            if (!Utils.doStatesMatch(s, state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IBlockState> getBlockStateMatchers() {
        return this.blockStateMatchers;
    }

    @Override
    public boolean oreMatches(IBlockState other) {
        return Utils.doStatesMatch(this.oreBlock, other);
    }

    @Override
    public boolean sampleMatches(IBlockState other) {
        return Utils.doStatesMatch(this.sampleBlock, other);
    }

    @Override
    public float getDensity() {
        return this.density;
    }
}

