/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.api.world;

import com.oitsjustjose.geolosys.common.api.world.IOre;
import com.oitsjustjose.geolosys.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DepositMultiOre
implements IOre {
    private ArrayList<IBlockState> ores = new ArrayList();
    private ArrayList<IBlockState> samples = new ArrayList();
    public HashMap<IBlockState, Integer> oreBlocks;
    public HashMap<IBlockState, Integer> sampleBlocks;
    private int yMin;
    private int yMax;
    private int size;
    private int chance;
    private int[] dimensionBlacklist;
    private List<IBlockState> blockStateMatchers;
    private float density;

    public DepositMultiOre(HashMap<IBlockState, Integer> oreBlocks, HashMap<IBlockState, Integer> sampleBlocks, int yMin, int yMax, int size, int chance, int[] dimensionBlacklist, List<IBlockState> blockStateMatchers, float density) {
        int i;
        int sum = 0;
        for (IBlockState key : oreBlocks.keySet()) {
            sum += oreBlocks.get(key).intValue();
        }
        assert (sum == 100) : "Sums of chances should equal 100";
        sum = 0;
        for (IBlockState key : sampleBlocks.keySet()) {
            sum += sampleBlocks.get(key).intValue();
        }
        assert (sum == 100) : "Sums of chances should equal 100";
        int last = 0;
        for (IBlockState key : oreBlocks.keySet()) {
            for (i = last; i < last + oreBlocks.get(key); ++i) {
                this.ores.add(i, key);
            }
            last += oreBlocks.get(key).intValue();
        }
        last = 0;
        for (IBlockState key : sampleBlocks.keySet()) {
            for (i = last; i < last + sampleBlocks.get(key); ++i) {
                this.samples.add(i, key);
            }
            last += sampleBlocks.get(key).intValue();
        }
        this.oreBlocks = (HashMap)oreBlocks.clone();
        this.sampleBlocks = (HashMap)sampleBlocks.clone();
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.chance = chance;
        this.dimensionBlacklist = dimensionBlacklist;
        this.blockStateMatchers = blockStateMatchers;
        this.density = density;
    }

    public ArrayList<IBlockState> getOres() {
        return this.ores;
    }

    public ArrayList<IBlockState> getSamples() {
        return this.samples;
    }

    @Override
    public IBlockState getOre() {
        IBlockState backup = null;
        try {
            return this.ores.get(new Random().nextInt(100));
        }
        catch (IndexOutOfBoundsException e) {
            block2: {
                IBlockState s;
                Iterator<IBlockState> iterator = this.oreBlocks.keySet().iterator();
                if (!iterator.hasNext()) break block2;
                backup = s = iterator.next();
            }
            return backup;
        }
    }

    @Override
    public IBlockState getSample() {
        IBlockState backup = null;
        try {
            return this.samples.get(new Random().nextInt(100));
        }
        catch (IndexOutOfBoundsException e) {
            block2: {
                IBlockState s;
                Iterator<IBlockState> iterator = this.sampleBlocks.keySet().iterator();
                if (!iterator.hasNext()) break block2;
                backup = s = iterator.next();
            }
            return backup;
        }
    }

    @Override
    public String getFriendlyName() {
        StringBuilder sb = new StringBuilder();
        for (IBlockState state : this.ores) {
            String name = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)).func_82833_r();
            if (sb.indexOf(name) != -1) continue;
            sb.append(" & ");
            sb.append(name);
        }
        return sb.toString().substring(3);
    }

    @Override
    public String getFriendlyName(World world, BlockPos pos, EntityPlayer player) {
        StringBuilder sb = new StringBuilder();
        for (IBlockState state : this.ores) {
            String name = Utils.blockStateToName(state, world, pos, player);
            if (sb.indexOf(name) != -1) continue;
            sb.append(" & ");
            sb.append(name);
        }
        return sb.toString().substring(3);
    }

    @Override
    public int getYMin() {
        return this.yMin;
    }

    @Override
    public int getYMax() {
        return this.yMax;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int[] getDimensionBlacklist() {
        return this.dimensionBlacklist;
    }

    @Override
    public boolean canReplace(IBlockState state) {
        if (this.blockStateMatchers == null) {
            return true;
        }
        for (IBlockState s : this.blockStateMatchers) {
            if (s != state) continue;
            return true;
        }
        return this.blockStateMatchers.contains(state);
    }

    @Override
    public List<IBlockState> getBlockStateMatchers() {
        return this.blockStateMatchers;
    }

    public boolean oreMatches(ArrayList<IBlockState> other) {
        for (IBlockState state1 : this.oreBlocks.keySet()) {
            boolean isMatchInOtherArrayList = false;
            for (IBlockState state2 : other) {
                if (!Utils.doStatesMatch(state1, state2)) continue;
                isMatchInOtherArrayList = true;
                break;
            }
            if (isMatchInOtherArrayList) continue;
            return false;
        }
        return this.oreBlocks.size() == other.size();
    }

    public boolean sampleMatches(ArrayList<IBlockState> other) {
        for (IBlockState state1 : this.sampleBlocks.keySet()) {
            boolean isMatchInOtherArrayList = false;
            for (IBlockState state2 : other) {
                if (!Utils.doStatesMatch(state1, state2)) continue;
                isMatchInOtherArrayList = true;
                break;
            }
            if (isMatchInOtherArrayList) continue;
            return false;
        }
        return this.sampleBlocks.size() == other.size();
    }

    @Override
    public boolean oreMatches(IBlockState other) {
        for (IBlockState s : this.ores) {
            if (!Utils.doStatesMatch(s, other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean sampleMatches(IBlockState other) {
        for (IBlockState s : this.samples) {
            if (!Utils.doStatesMatch(s, other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getDensity() {
        return this.density;
    }
}

