/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.blocks.Types;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.items.ItemCluster;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOre
extends Block {
    public static final PropertyEnum<Types.Modded> VARIANT = PropertyEnum.func_177709_a((String)"variant", Types.Modded.class);
    public static final String[] oreDictByMeta = new String[]{"oreIron", "oreNickel", "oreCopper", "oreCopper", "oreTin", "oreTin", "oreGalena", "oreAluminum", "orePlatinum", "oreUranium", "oreZinc"};

    public BlockOre() {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("geolosys", "ore"));
        this.func_149711_c(7.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Types.Modded.HEMATITE)));
        this.func_149663_c(this.getRegistryName().toString().replaceAll(":", "."));
        this.setHarvestLevels();
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)new ItemBlockOre(this));
        this.registerOreDict();
    }

    private void registerOreDict() {
        for (int i = 0; i < Types.Modded.values().length; ++i) {
            OreDictionary.registerOre((String)("oreBlock" + Types.Modded.values()[i].func_176610_l().substring(0, 1).toUpperCase() + Types.Modded.values()[i].func_176610_l().substring(1)), (ItemStack)new ItemStack((Block)this, 1, i));
        }
    }

    private void setHarvestLevels() {
        for (Types.Modded t : Types.Modded.values()) {
            this.setHarvestLevel("pickaxe", t.getToolLevel(), this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)t)));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Geolosys.getInstance().CLUSTER;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Item CLUSTER = Geolosys.getInstance().CLUSTER;
        if (state.func_177230_c().func_176201_c(state) == 1) {
            int count;
            int rng;
            Random rand = new Random();
            int n = rng = ModConfig.featureControl.enableFortuneOnAllOres ? rand.nextInt(5 - Math.min(3, fortune)) : rand.nextInt(5);
            int n2 = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : (count = 1);
            if (rng == 0) {
                drops.add((Object)new ItemStack(CLUSTER, count, 7));
            } else {
                drops.add((Object)new ItemStack(CLUSTER, count, 0));
            }
        } else if (state.func_177230_c().func_176201_c(state) == 6) {
            int count;
            Random rand = new Random();
            boolean rng = rand.nextBoolean();
            int n = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : (count = 1);
            if (rng) {
                drops.add((Object)new ItemStack(CLUSTER, count, 4));
                rng = rand.nextBoolean();
                if (rng) {
                    count = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : 1;
                    drops.add((Object)new ItemStack(CLUSTER, count, 5));
                }
            } else {
                drops.add((Object)new ItemStack(CLUSTER, count, 5));
            }
        } else if (state.func_177230_c().func_176201_c(state) == 8) {
            if (ModConfig.compat.enableOsmiumExclusively) {
                Random rand = new Random();
                int count = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : 1;
                drops.add((Object)new ItemStack(CLUSTER, count, 12));
            } else if (ModConfig.compat.enableOsmium) {
                int count;
                Random rand = new Random();
                boolean rng = rand.nextBoolean();
                int n = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : (count = 1);
                if (rng) {
                    drops.add((Object)new ItemStack(CLUSTER, count, 8));
                } else {
                    drops.add((Object)new ItemStack(CLUSTER, count, 12));
                }
            } else {
                Random rand = new Random();
                int count = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : 1;
                drops.add((Object)new ItemStack(CLUSTER, count, 8));
            }
        } else if (state.func_177230_c().func_176201_c(state) == 9) {
            if (ModConfig.compat.enableYellorium) {
                int count;
                Random rand = new Random();
                boolean rng = rand.nextBoolean();
                int n = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : (count = 1);
                if (rng) {
                    drops.add((Object)new ItemStack(CLUSTER, count, 9));
                } else {
                    drops.add((Object)new ItemStack(CLUSTER, count, 11));
                }
            } else {
                Random rand = new Random();
                int count = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : 1;
                drops.add((Object)new ItemStack(CLUSTER, count, 9));
            }
        } else {
            Random rand = new Random();
            int count = fortune > 0 ? (ModConfig.featureControl.enableFortuneOnAllOres ? Math.max(1, rand.nextInt(fortune) + 1) : 1) : 1;
            drops.add((Object)new ItemStack(CLUSTER, count, this.func_180651_a(state)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return !this.func_180643_i(state).func_190926_b();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        Random rand = new Random();
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == 1) {
            if (rand.nextInt(5) == 0) {
                return this.getOreDictAlternative("oreNickel");
            }
            return this.getOreDictAlternative("oreIron");
        }
        if (meta == 6) {
            if (rand.nextBoolean()) {
                return this.getOreDictAlternative("oreSilver");
            }
            return this.getOreDictAlternative("oreLead");
        }
        if (meta == 8) {
            if (ModConfig.compat.enableOsmiumExclusively) {
                return this.getOreDictAlternative("oreOsmium");
            }
            if (ModConfig.compat.enableOsmium) {
                if (rand.nextBoolean()) {
                    return this.getOreDictAlternative("oreOsmium");
                }
                return this.getOreDictAlternative("orePlatinum");
            }
            return this.getOreDictAlternative("orePlatinum");
        }
        if (meta == 9) {
            if (ModConfig.compat.enableYellorium) {
                if (rand.nextBoolean()) {
                    return this.getOreDictAlternative("oreYellorium");
                }
                return this.getOreDictAlternative("oreUranium");
            }
            return this.getOreDictAlternative("oreUranium");
        }
        return this.getOreDictAlternative(oreDictByMeta[meta]);
    }

    private ItemStack getOreDictAlternative(String oreName) {
        for (ItemStack i : OreDictionary.getOres((String)oreName)) {
            if (i.func_77973_b() instanceof ItemCluster) continue;
            ItemStack retStack = i.func_77946_l();
            retStack.func_190920_e(1);
            return retStack;
        }
        return ItemStack.field_190927_a;
    }

    public int func_180651_a(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        switch (meta) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, this.func_176201_c(state));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Modded.byMetadata(meta)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Modded.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Types.Modded)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public class ItemBlockOre
    extends ItemBlock {
        ItemBlockOre(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
            this.func_77656_e(0);
            this.registerModels();
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + Types.Modded.byMetadata(stack.func_77960_j()).func_176610_l();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < Types.Modded.values().length; ++i) {
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        private void registerModels() {
            for (int i = 0; i < Types.Modded.values().length; ++i) {
                Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), VARIANT.func_177701_a() + "=" + Types.Modded.byMetadata(i).func_176610_l());
            }
        }
    }
}

