/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.config;

import com.google.gson.stream.JsonReader;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.util.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ConfigOres {
    private File jsonFile;
    private ArrayList<PendingOre> pendingOres;
    private ArrayList<PendingStone> pendingStones;

    public ConfigOres(File configRoot) {
        this.jsonFile = new File(configRoot.getAbsolutePath() + "/geolosys.json");
        this.pendingOres = new ArrayList();
        this.pendingStones = new ArrayList();
    }

    public void postInit() {
        for (PendingOre pendingOre : this.pendingOres) {
            if (this.register(pendingOre)) {
                Geolosys.getInstance().LOGGER.info("Successfully registered JSON entry " + pendingOre.oreBlocks.keySet() + " **LATE**. This means that ore gen will work, but inter-mod compat may not");
                continue;
            }
            Geolosys.getInstance().LOGGER.info("Failed to register JSON entry " + pendingOre.oreBlocks.keySet() + ". Please ensure that all entries are correct. This ore entry has been skipped completely");
        }
        for (PendingStone pendingStone : this.pendingStones) {
            if (this.register(pendingStone)) {
                Geolosys.getInstance().LOGGER.info("Successfully registered JSON entry " + pendingStone.stone + " **LATE**. This means that stone gen will work, but inter-mod compat may not");
                continue;
            }
            Geolosys.getInstance().LOGGER.info("Failed to register JSON entry " + pendingStone.stone + ". Please ensure that all entries are correct. This stone entry has been skipped completely");
        }
    }

    public void init() {
        try {
            FileInputStream jsonStream = new FileInputStream(this.jsonFile);
            this.read(jsonStream);
        }
        catch (IOException e) {
            try {
                Geolosys.getInstance().LOGGER.info("Could not find geolosys.json. Downloading it from GitHub...");
                BufferedInputStream in = new BufferedInputStream(new URL("https://raw.githubusercontent.com/oitsjustjose/Geolosys/1.12.x/geolosys_ores.json").openStream());
                Files.copy(in, Paths.get(this.jsonFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                Geolosys.getInstance().LOGGER.info("Done downloading geolosys.json from GitHub!");
                FileInputStream jsonStream = new FileInputStream(this.jsonFile);
                this.read(jsonStream);
            }
            catch (IOException f) {
                Geolosys.proxy.throwDownloadError(this.jsonFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(InputStream in) throws IOException {
        try (JsonReader jReader = new JsonReader((Reader)new InputStreamReader(in));){
            jReader.beginObject();
            while (jReader.hasNext()) {
                int size;
                String name = jReader.nextName();
                if (name.equalsIgnoreCase("ores")) {
                    jReader.beginArray();
                    while (jReader.hasNext()) {
                        HashMap<String, Integer> oreBlocks = new HashMap<String, Integer>();
                        HashMap<String, Integer> sampleBlocks = new HashMap<String, Integer>();
                        int yMin = -1;
                        int yMax = -1;
                        size = -1;
                        int chance = -1;
                        int[] dimBlacklist = new int[]{};
                        ArrayList<String> blockStateMatchers = new ArrayList<String>();
                        ArrayList<Biome> biomes = new ArrayList<Biome>();
                        ArrayList<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
                        boolean isWhitelist = false;
                        boolean hasIsWhitelist = false;
                        float density = 1.0f;
                        jReader.beginObject();
                        while (jReader.hasNext()) {
                            String subName = jReader.nextName();
                            if (subName.equalsIgnoreCase("blocks")) {
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    oreBlocks.put(jReader.nextString(), jReader.nextInt());
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("samples")) {
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    sampleBlocks.put(jReader.nextString(), jReader.nextInt());
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMin")) {
                                yMin = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMax")) {
                                yMax = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("size")) {
                                size = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("chance")) {
                                chance = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("dimBlacklist")) {
                                ArrayList<Integer> tmp = new ArrayList<Integer>();
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    tmp.add(jReader.nextInt());
                                }
                                jReader.endArray();
                                dimBlacklist = this.fromArrayList(tmp);
                                continue;
                            }
                            if (subName.equalsIgnoreCase("blockStateMatchers")) {
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    blockStateMatchers.add(jReader.nextString());
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("biomes")) {
                                jReader.beginArray();
                                block12: while (jReader.hasNext()) {
                                    String testFor = jReader.nextString();
                                    Biome b = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(testFor));
                                    if (b != null) {
                                        biomes.add(b);
                                        continue;
                                    }
                                    for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
                                        if (!biomeType.getName().equalsIgnoreCase(testFor)) continue;
                                        biomeTypes.add(biomeType);
                                        continue block12;
                                    }
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("isWhitelist")) {
                                isWhitelist = jReader.nextBoolean();
                                hasIsWhitelist = true;
                                continue;
                            }
                            if (subName.equalsIgnoreCase("density")) {
                                density = (float)jReader.nextDouble();
                                continue;
                            }
                            Geolosys.getInstance().LOGGER.info("Unknown property found in geolosys_ores.json file. Skipping it.");
                            jReader.skipValue();
                        }
                        if (!this.register(oreBlocks, sampleBlocks, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers, biomes, biomeTypes, isWhitelist, hasIsWhitelist, density)) {
                            this.pendingOres.add(new PendingOre(oreBlocks, sampleBlocks, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers, biomes, biomeTypes, isWhitelist, hasIsWhitelist, density));
                        }
                        jReader.endObject();
                    }
                    jReader.endArray();
                    continue;
                }
                if (name.equalsIgnoreCase("stones")) {
                    jReader.beginArray();
                    while (jReader.hasNext()) {
                        jReader.beginObject();
                        String stone = null;
                        int yMin = -1;
                        int yMax = -1;
                        int chance = -1;
                        size = -1;
                        int[] dimBlacklist = new int[]{};
                        while (jReader.hasNext()) {
                            String subName = jReader.nextName();
                            if (subName.equalsIgnoreCase("block")) {
                                stone = jReader.nextString();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMin")) {
                                yMin = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMax")) {
                                yMax = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("size")) {
                                size = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("chance")) {
                                chance = jReader.nextInt();
                                continue;
                            }
                            if (!subName.equalsIgnoreCase("dimBlacklist")) continue;
                            ArrayList<Integer> tmp = new ArrayList<Integer>();
                            jReader.beginArray();
                            while (jReader.hasNext()) {
                                tmp.add(jReader.nextInt());
                            }
                            jReader.endArray();
                            dimBlacklist = this.fromArrayList(tmp);
                        }
                        if (!this.register(stone, yMin, yMax, chance, size, dimBlacklist)) {
                            this.pendingStones.add(new PendingStone(stone, yMin, yMax, chance, size, dimBlacklist));
                        }
                        jReader.endObject();
                    }
                    jReader.endArray();
                    continue;
                }
                jReader.skipValue();
            }
            jReader.endObject();
        }
    }

    private boolean register(PendingStone stone) {
        return this.register(stone.stone, stone.yMin, stone.yMax, stone.chance, stone.size, stone.dimBlacklist);
    }

    private boolean register(String stone, int yMin, int yMax, int chance, int size, int[] dimBlacklist) {
        IBlockState state = this.fromString(stone);
        if (state == null) {
            return false;
        }
        GeolosysAPI.registerStoneDeposit(state, yMin, yMax, chance, size, dimBlacklist);
        return true;
    }

    private boolean register(PendingOre ore) {
        return this.register(ore.oreBlocks, ore.sampleBlocks, ore.yMin, ore.yMax, ore.size, ore.chance, ore.dimBlacklist, ore.blockStateMatchers, ore.biomes, ore.biomeTypes, ore.isWhitelist, ore.hasIsWhitelist, ore.density);
    }

    private boolean register(HashMap<String, Integer> oreBlocks, HashMap<String, Integer> sampleBlocks, int yMin, int yMax, int size, int chance, int[] dimBlacklist, ArrayList<String> blockStateMatchers, ArrayList<Biome> biomes, List<BiomeDictionary.Type> biomeTypes, boolean isWhitelist, boolean hasIsWhitelist, float density) {
        IBlockState state;
        HashMap<IBlockState, Integer> oreBlocksParsed = new HashMap<IBlockState, Integer>();
        HashMap<IBlockState, Integer> sampleBlocksParsed = new HashMap<IBlockState, Integer>();
        ArrayList<IBlockState> blockStateMatchersParsed = new ArrayList<IBlockState>();
        for (Map.Entry<String, Integer> e : oreBlocks.entrySet()) {
            state = this.fromString(e.getKey());
            if (state == null) {
                return false;
            }
            oreBlocksParsed.put(state, e.getValue());
        }
        for (Map.Entry<String, Integer> e : sampleBlocks.entrySet()) {
            state = this.fromString(e.getKey());
            if (state == null) {
                return false;
            }
            sampleBlocksParsed.put(state, e.getValue());
        }
        for (String s : blockStateMatchers) {
            state = this.fromString(s);
            if (state == null) {
                return false;
            }
            blockStateMatchersParsed.add(state);
        }
        if (biomes.size() > 0 || biomeTypes.size() > 0) {
            if (hasIsWhitelist) {
                GeolosysAPI.registerMineralDeposit(oreBlocksParsed, sampleBlocksParsed, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers.size() == 0 ? null : blockStateMatchersParsed, biomes, biomeTypes, isWhitelist, density);
            } else {
                Geolosys.getInstance().LOGGER.info("Received a biome list but no isWhitelist variable to define if the biome list is whitelist or blacklist.\nRegistering it as a normal ore with no biome restrictions");
                GeolosysAPI.registerMineralDeposit(oreBlocksParsed, sampleBlocksParsed, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers.size() == 0 ? null : blockStateMatchersParsed, density);
            }
        } else {
            GeolosysAPI.registerMineralDeposit(oreBlocksParsed, sampleBlocksParsed, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers.size() == 0 ? null : blockStateMatchersParsed, density);
        }
        Geolosys.getInstance().LOGGER.info("Registered " + oreBlocks + ", " + sampleBlocks + " with density " + density + ". " + (biomeTypes.size() > 0 || biomes.size() > 0 ? "This ore has custom biome registries" : ""));
        return true;
    }

    private IBlockState fromString(String iBlockState) {
        String[] parts = iBlockState.split(":");
        if (parts.length == 2) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
            return b.func_176223_P();
        }
        if (parts.length == 3) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
            return Utils.getStateFromMeta(b, Integer.parseInt(parts[2]));
        }
        return null;
    }

    private int[] fromArrayList(ArrayList<Integer> arrList) {
        int[] retVal = new int[arrList.size()];
        for (int i = 0; i < arrList.size(); ++i) {
            retVal[i] = arrList.get(i);
        }
        return retVal;
    }

    private static class PendingStone {
        public String stone;
        public int yMin;
        public int yMax;
        public int chance;
        public int size;
        public int[] dimBlacklist;

        public PendingStone(String stone, int yMin, int yMax, int chance, int size, int[] dimBlacklist) {
            this.stone = stone;
            this.yMin = yMin;
            this.yMax = yMax;
            this.chance = chance;
            this.size = size;
            this.dimBlacklist = dimBlacklist;
        }
    }

    private static class PendingOre {
        public HashMap<String, Integer> oreBlocks;
        public HashMap<String, Integer> sampleBlocks;
        public int yMin;
        public int yMax;
        public int size;
        public int chance;
        public int[] dimBlacklist;
        public ArrayList<String> blockStateMatchers;
        public ArrayList<Biome> biomes;
        public List<BiomeDictionary.Type> biomeTypes;
        public boolean isWhitelist;
        public boolean hasIsWhitelist;
        public float density;

        public PendingOre(HashMap<String, Integer> oreBlocks, HashMap<String, Integer> sampleBlocks, int yMin, int yMax, int size, int chance, int[] dimBlacklist, ArrayList<String> blockStateMatchers, ArrayList<Biome> biomes, List<BiomeDictionary.Type> biomeTypes, boolean isWhitelist, boolean hasIsWhitelist, float density) {
            this.oreBlocks = oreBlocks;
            this.sampleBlocks = sampleBlocks;
            this.yMin = yMin;
            this.yMax = yMax;
            this.size = size;
            this.chance = chance;
            this.dimBlacklist = dimBlacklist;
            this.blockStateMatchers = blockStateMatchers;
            this.biomes = biomes;
            this.biomeTypes = biomeTypes;
            this.isWhitelist = isWhitelist;
            this.hasIsWhitelist = hasIsWhitelist;
            this.density = density;
        }
    }
}

