/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.config;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.util.Utils;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ConfigParser {
    private static ConfigParser instance;

    public ConfigParser() {
        this.parsePredicates();
        this.parseConverterBlacklist();
        this.parseDimensions();
        this.parseProPickExtras();
    }

    public static void init() {
        instance = new ConfigParser();
    }

    public static void reinit() {
        instance.parseDimensions();
        instance.parseConverterBlacklist();
        instance.parseProPickExtras();
    }

    private void parseProPickExtras() {
        block2: for (String str : ModConfig.prospecting.extraProPickEntries) {
            String[] parts = str.split(":");
            if (parts.length == 2 || parts.length == 3) {
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
                if (b != null && b != Blocks.field_150350_a) {
                    if (parts.length == 3) {
                        if (parts[2].equals("*")) {
                            for (int i = 0; i < 16; ++i) {
                                try {
                                    GeolosysAPI.proPickExtras.add(b.func_176203_a(i));
                                    continue;
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    continue block2;
                                }
                            }
                            continue;
                        }
                        GeolosysAPI.proPickExtras.add(Utils.getStateFromMeta(b, Integer.parseInt(parts[2])));
                        continue;
                    }
                    GeolosysAPI.proPickExtras.add(b.func_176223_P());
                    continue;
                }
                Geolosys.getInstance().LOGGER.info("ProPick extra entry " + str + " does not exist or hasn't been registered yet");
                continue;
            }
            Geolosys.getInstance().LOGGER.info("ProPick extra entry " + str + " is not valid. Please ensure it's in form modid:block or modid:block:metadata");
        }
    }

    private void parseDimensions() {
        if (Geolosys.getInstance().PRO_PICK == null) {
            return;
        }
        HashMap<Integer, Integer> dimensionSeaLevels = new HashMap<Integer, Integer>();
        for (String s : ModConfig.prospecting.proPickDimensionSeaLevels) {
            String[] parts = s.trim().replace(" ", "").split(":");
            if (parts.length != 2) {
                Geolosys.getInstance().LOGGER.info("Entry " + s + " is not a valid entry for proPickDimensionSeaLevels. Reason: Wrong number of args.");
                continue;
            }
            dimensionSeaLevels.put(this.toInt(parts[0]), this.toInt(parts[1]));
        }
    }

    private void parsePredicates() {
        for (String s : ModConfig.userEntries.replacementMatsRaw) {
            String[] parts = s.trim().replaceAll(" ", "").replaceAll("<", "").replaceAll(">", "").split(":");
            if (parts.length != 2 && parts.length != 3) {
                Geolosys.getInstance().LOGGER.error("Entry " + s + " is not valid. Reason: wrong number of arguments given");
                continue;
            }
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
                if (block == null || block == Blocks.field_150350_a) {
                    Geolosys.getInstance().LOGGER.error("Entry " + s + " is not valid. Reason: predicate block does not exist");
                    continue;
                }
                if (parts.length == 2) {
                    GeolosysAPI.replacementMats.add(block.func_176223_P());
                    continue;
                }
                if (parts[2].equals("*")) {
                    for (int i = 0; i < 16; ++i) {
                        GeolosysAPI.replacementMats.add(Utils.getStateFromMeta(block, i));
                    }
                    continue;
                }
                GeolosysAPI.replacementMats.add(Utils.getStateFromMeta(block, this.toInt(parts[2])));
            }
            catch (NumberFormatException e) {
                Geolosys.getInstance().LOGGER.error("Entry " + s + " is not valid. Reason: this entry doesn't have a number where there's supposed to be");
                Geolosys.getInstance().LOGGER.error("Additional Info: " + e.getMessage());
            }
        }
    }

    private void parseConverterBlacklist() {
        for (String s : ModConfig.userEntries.convertBlacklistRaw) {
            String[] parts = s.trim().replaceAll(" ", "").split("[\\W]");
            if (parts.length != 2 && parts.length != 3) {
                Geolosys.getInstance().LOGGER.error("Entry " + s + " is not valid. Reason: wrong number of arguments given");
                continue;
            }
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
                if (block == null || block == Blocks.field_150350_a) {
                    Geolosys.getInstance().LOGGER.error("Entry " + s + " is not valid. Reason: ore swap blacklist block does not exist");
                    continue;
                }
                if (parts.length == 2) {
                    GeolosysAPI.oreConverterBlacklist.add(block.func_176223_P());
                    continue;
                }
                if (parts[2].equals("*")) {
                    for (int i = 0; i < 16; ++i) {
                        GeolosysAPI.oreConverterBlacklist.add(Utils.getStateFromMeta(block, i));
                    }
                    continue;
                }
                GeolosysAPI.oreConverterBlacklist.add(Utils.getStateFromMeta(block, this.toInt(parts[2])));
            }
            catch (NumberFormatException e) {
                Geolosys.getInstance().LOGGER.error("Entry " + s + " is not valid. Reason: this entry doesn't have a number where there's supposed to be");
                Geolosys.getInstance().LOGGER.error("Additional Info: " + e.getMessage());
            }
        }
    }

    private int toInt(String s) {
        return Integer.parseInt(s);
    }
}

