/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.util;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class GeolosysSaveData
extends WorldSavedData {
    private boolean hasOldFiles;

    public GeolosysSaveData() {
        super("geolosys");
        this.func_76185_a();
        this.hasOldFiles = new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "GeolosysDeposits.dat").exists() || new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "GeolosysRegen.dat").exists();
    }

    public GeolosysSaveData(String s) {
        super(s);
        this.func_76185_a();
        this.hasOldFiles = new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "GeolosysDeposits.dat").exists() || new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "GeolosysRegen.dat").exists();
    }

    private void convertFromOld(NBTTagCompound nbt) {
        File depositFileLocation = new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "GeolosysDeposits.dat");
        File regenFileLocation = new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "GeolosysRegen.dat");
        HashMap<Object, Object> currentWorldDepositsDeprecated = new HashMap();
        LinkedHashMap<Object, Object> regennedChunksDeprecated = new LinkedHashMap();
        if (DimensionManager.getCurrentSaveRootDirectory() != null) {
            if (depositFileLocation.exists()) {
                currentWorldDepositsDeprecated = GeolosysAPI.getDeposits(depositFileLocation);
                if (depositFileLocation.delete()) {
                    Geolosys.getInstance().LOGGER.info("Deleted old depositFile");
                }
            }
            if (regenFileLocation.exists()) {
                regennedChunksDeprecated = GeolosysAPI.getRegennedChunks(regenFileLocation);
                if (regenFileLocation.delete()) {
                    Geolosys.getInstance().LOGGER.info("Deleted old regenFile");
                }
            }
            this.hasOldFiles = false;
            for (Map.Entry<Object, Object> e : currentWorldDepositsDeprecated.entrySet()) {
                GeolosysAPI.putWorldDeposit((GeolosysAPI.ChunkPosSerializable)e.getKey(), (String)e.getValue());
            }
            for (Map.Entry<Object, Object> e : regennedChunksDeprecated.entrySet()) {
                if (!((Boolean)e.getValue()).booleanValue()) continue;
                GeolosysAPI.markChunkRegenned((GeolosysAPI.ChunkPosSerializable)e.getKey());
            }
            this.func_189551_b(nbt);
        }
    }

    public void func_76184_a(NBTTagCompound compound) {
        if (this.hasOldFiles) {
            Geolosys.getInstance().LOGGER.info("Geolosys is converting old persistent files into Forge World Data.");
            this.convertFromOld(compound);
            Geolosys.getInstance().LOGGER.info("Geolosys World Data conversion complete!");
        }
        if (compound.func_74764_b("currentWorldDeposits")) {
            NBTTagCompound compDeposits = compound.func_74775_l("currentWorldDeposits");
            for (String s : compDeposits.func_150296_c()) {
                GeolosysAPI.putWorldDeposit(s, compDeposits.func_74779_i(s));
            }
        }
        if (compound.func_74764_b("regennedChunks")) {
            NBTTagCompound compRegenned = compound.func_74775_l("regennedChunks");
            for (String s : compRegenned.func_150296_c()) {
                if (!compRegenned.func_74767_n(s)) continue;
                GeolosysAPI.markChunkRegenned(s);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        if (!compound.func_74764_b("currentWorldDeposits")) {
            compound.func_74782_a("currentWorldDeposits", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound compDeposits = compound.func_74775_l("currentWorldDeposits");
        for (Map.Entry<GeolosysAPI.ChunkPosSerializable, String> e : GeolosysAPI.getCurrentWorldDeposits().entrySet()) {
            compDeposits.func_74778_a(e.getKey().toString(), e.getValue());
        }
        if (!compound.func_74764_b("regennedChunks")) {
            compound.func_74782_a("regennedChunks", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound regenDeposits = compound.func_74775_l("regennedChunks");
        for (Map.Entry<GeolosysAPI.ChunkPosSerializable, Boolean> e : GeolosysAPI.getRegennedChunks().entrySet()) {
            regenDeposits.func_74757_a(e.getKey().toString(), e.getValue().booleanValue());
        }
        return compound;
    }

    public static GeolosysSaveData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        GeolosysSaveData instance = (GeolosysSaveData)storage.func_75742_a(GeolosysSaveData.class, "geolosys");
        if (instance == null) {
            instance = new GeolosysSaveData();
            storage.func_75745_a("geolosys", (WorldSavedData)instance);
        }
        return instance;
    }
}

