/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.common.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.common.api.world.IOre;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.util.GeolosysSaveData;
import com.oitsjustjose.geolosys.common.world.ToDoBlocks;
import com.oitsjustjose.geolosys.common.world.WorldGenMinableSafe;
import com.oitsjustjose.geolosys.compat.UBCompat;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;

public class OreGenerator
implements IWorldGenerator {
    private static final String dataID = "geolosysOreGeneratorPending";
    private static HashMap<Integer, OreGen> oreSpawnWeights = new HashMap();
    private static int last = 0;

    public static void addOreGen(IOre ore) {
        OreGen gen = new OreGen(ore);
        for (int i = last; i < last + ore.getChance(); ++i) {
            oreSpawnWeights.put(i, gen);
        }
        last += ore.getChance();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ToDoBlocks.getForWorld(world, dataID).processPending(new ChunkPos(chunkX, chunkZ), world);
        if (oreSpawnWeights.keySet().size() > 0) {
            int rng = random.nextInt(oreSpawnWeights.keySet().size());
            if (OreGenerator.oreSpawnWeights.get((Object)Integer.valueOf((int)rng)).ore instanceof DepositBiomeRestricted) {
                DepositBiomeRestricted deposit = (DepositBiomeRestricted)OreGenerator.oreSpawnWeights.get((Object)Integer.valueOf((int)rng)).ore;
                if (deposit.canPlaceInBiome(world.func_180494_b(new BlockPos(chunkX * 16, 256, chunkZ * 16)))) {
                    oreSpawnWeights.get(rng).generate(world, random, chunkX * 16, chunkZ * 16);
                }
            } else if (OreGenerator.oreSpawnWeights.get((Object)Integer.valueOf((int)rng)).ore instanceof DepositMultiOreBiomeRestricted) {
                DepositMultiOreBiomeRestricted deposit = (DepositMultiOreBiomeRestricted)OreGenerator.oreSpawnWeights.get((Object)Integer.valueOf((int)rng)).ore;
                if (deposit.canPlaceInBiome(world.func_180494_b(new BlockPos(chunkX * 16, 256, chunkZ * 16)))) {
                    oreSpawnWeights.get(rng).generate(world, random, chunkX * 16, chunkZ * 16);
                }
            } else {
                oreSpawnWeights.get(rng).generate(world, random, chunkX * 16, chunkZ * 16);
            }
        }
        if (Loader.isModLoaded((String)"undergroundbiomes") && ModConfig.compat.enableUBGCompat) {
            UBCompat.forceReprocess(chunkGenerator, world, random, chunkX, chunkZ);
        }
    }

    public static class OreGen {
        WorldGenMinableSafe pluton;
        IOre ore;

        public OreGen(IOre ore) {
            this.pluton = new WorldGenMinableSafe(ore, OreGenerator.dataID);
            this.ore = ore;
        }

        public void generate(World world, Random rand, int x, int z) {
            if (!Geolosys.getInstance().chunkOreGen.canGenerateInChunk(world, new ChunkPos(x / 16, z / 16), world.field_73011_w.getDimension())) {
                return;
            }
            boolean lastState = ForgeModContainer.logCascadingWorldGeneration;
            ForgeModContainer.logCascadingWorldGeneration = false;
            for (int d : this.ore.getDimensionBlacklist()) {
                if (d != world.field_73011_w.getDimension()) continue;
                return;
            }
            if (rand.nextInt(100) < this.ore.getChance()) {
                int y;
                int n = y = this.ore.getYMin() != this.ore.getYMax() ? this.ore.getYMin() + rand.nextInt(this.ore.getYMax() - this.ore.getYMin()) : this.ore.getYMin();
                if (Loader.isModLoaded((String)"twilightforest") && world.field_73011_w.getDimension() == 7) {
                    y /= 2;
                    y /= 2;
                }
                if (this.pluton.func_180709_b(world, rand, new BlockPos(x, y, z))) {
                    IBlockState tmp = this.ore.getOre();
                    GeolosysAPI.putWorldDeposit(new ChunkPos(x / 16, z / 16), world.field_73011_w.getDimension(), tmp.func_177230_c().getRegistryName() + ":" + tmp.func_177230_c().func_176201_c(tmp));
                    GeolosysSaveData.get(world).func_76185_a();
                    Geolosys.getInstance().chunkOreGen.addChunk(new ChunkPos(x / 16, z / 16), world, y, this.ore);
                }
            }
            ForgeModContainer.logCascadingWorldGeneration = lastState;
        }
    }
}

