/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.world.DepositStone;
import com.oitsjustjose.geolosys.common.world.ToDoBlocks;
import com.oitsjustjose.geolosys.common.world.WorldGenMinableSafe;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StoneGenerator
implements IWorldGenerator {
    private static final String dataID = "geolosysStoneGeneratorPending";
    private static HashMap<Integer, StoneGen> stoneSpawnWeights = new HashMap();
    private static int last = 0;

    public static void addStoneGen(DepositStone stone) {
        StoneGen gen = new StoneGen(stone);
        for (int i = last; i < last + stone.getChance(); ++i) {
            stoneSpawnWeights.put(i, gen);
        }
        last += stone.getChance();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ToDoBlocks.getForWorld(world, dataID).processPending(new ChunkPos(chunkX, chunkZ), world);
        if (world.field_73011_w.getDimension() == 1 || world.field_73011_w.getDimension() == -1) {
            return;
        }
        if (stoneSpawnWeights.keySet().size() > 0) {
            int rng = random.nextInt(stoneSpawnWeights.keySet().size());
            stoneSpawnWeights.get(rng).generate(world, random, chunkX * 16, chunkZ * 16);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)chunkGenerator, (World)world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)true);
    }

    public static class StoneGen {
        WorldGenMinableSafe pluton;
        DepositStone depositStone;

        StoneGen(DepositStone depositStone) {
            this.pluton = new WorldGenMinableSafe(depositStone, StoneGenerator.dataID);
            this.depositStone = depositStone;
        }

        public void generate(World world, Random rand, int x, int z) {
            if (!Geolosys.getInstance().chunkOreGen.canGenerateInChunk(world, new ChunkPos(x / 16, z / 16), world.field_73011_w.getDimension())) {
                return;
            }
            boolean lastState = ForgeModContainer.logCascadingWorldGeneration;
            ForgeModContainer.logCascadingWorldGeneration = false;
            for (int d : this.depositStone.getDimensionBlacklist()) {
                if (d != world.field_73011_w.getDimension()) continue;
                return;
            }
            if (rand.nextInt(100) < this.depositStone.getChance()) {
                int y = this.depositStone.getYMin() != this.depositStone.getYMax() ? this.depositStone.getYMin() + rand.nextInt(this.depositStone.getYMax() - this.depositStone.getYMin()) : this.depositStone.getYMin();
                this.pluton.func_180709_b(world, rand, new BlockPos(x, y, z));
            }
            ForgeModContainer.logCascadingWorldGeneration = lastState;
        }
    }
}

