/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.compat;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.compat.ActAddCompat;
import com.oitsjustjose.geolosys.compat.AppEngCompat;
import com.oitsjustjose.geolosys.compat.ExUtilsCompat;
import com.oitsjustjose.geolosys.compat.IECompat;
import com.oitsjustjose.geolosys.compat.ModMaterials;
import com.oitsjustjose.geolosys.compat.NCCompat;
import com.oitsjustjose.geolosys.compat.OreConverter;
import com.oitsjustjose.geolosys.compat.ThaumcraftCompat;
import com.oitsjustjose.geolosys.compat.ThermExpCompat;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Logger;

public class CompatLoader {
    private Logger logger;

    public static void init() {
        new CompatLoader();
    }

    public CompatLoader() {
        ModMaterials.init();
        this.logger = Geolosys.getInstance().LOGGER;
        this.initCompats();
    }

    private void initCompats() {
        if (Loader.isModLoaded((String)"nuclearcraft")) {
            this.logger.info("Loading nuclearcraft compatibility");
            MinecraftForge.EVENT_BUS.register((Object)new NCCompat());
        }
        if (Loader.isModLoaded((String)"extrautils2")) {
            this.logger.info("Loading Extra Utilities compatibility");
            MinecraftForge.EVENT_BUS.register((Object)new ExUtilsCompat());
        }
        if (Loader.isModLoaded((String)"appliedenergistics2") && ModConfig.compat.enableAE2Compat) {
            this.logger.info("Loading Applied Energistics compatibility");
            MinecraftForge.EVENT_BUS.register((Object)new AppEngCompat());
        }
        if (Loader.isModLoaded((String)"thermalfoundation")) {
            this.logger.info("Loading Thermal Foundation compatibility");
            MinecraftForge.EVENT_BUS.register((Object)new ThermExpCompat());
        }
        if (Loader.isModLoaded((String)"thaumcraft")) {
            this.logger.info("Loading Thaumcraft compatibility");
            MinecraftForge.EVENT_BUS.register((Object)new ThaumcraftCompat());
        }
        if (Loader.isModLoaded((String)"actuallyadditions")) {
            this.logger.info("Loading Actually Additions compatibility");
            MinecraftForge.EVENT_BUS.register((Object)new ActAddCompat());
        }
        if (Loader.isModLoaded((String)"immersiveengineering") && ModConfig.compat.enableIECompat) {
            this.logger.info("Loading Immersive Engineering compatibility");
            IECompat.init();
        }
        if (ModConfig.featureControl.retroReplace) {
            MinecraftForge.EVENT_BUS.register((Object)new OreConverter());
        }
    }
}

