/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.compat;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.api.world.DepositMultiOre;
import com.oitsjustjose.geolosys.common.api.world.IOre;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.compat.ModMaterials;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class IECompat {
    public static void init() {
        OreDictionary.registerOre((String)"clumpCoal", (Item)Items.field_151044_h);
        if (ModConfig.compat.enableAE2Compat && ModMaterials.AE_MATERIAL != null) {
            OreDictionary.registerOre((String)"crystalCertusQuartzCharged", (ItemStack)new ItemStack(ModMaterials.AE_MATERIAL, 1, 1));
        }
        IECompat.initExcavatorCompat();
        IECompat.initCrusherCompat();
        IECompat.initBlastCompat();
        IECompat.initCokeCompat();
    }

    private static void initExcavatorCompat() {
        LinkedHashMap list = (LinkedHashMap)ExcavatorHandler.mineralList.clone();
        for (ExcavatorHandler.MineralMix mix : list.keySet()) {
            for (String name : ModConfig.compat.ieExcavatorRecipesToRemove) {
                if (!mix.name.equalsIgnoreCase(name)) continue;
                ExcavatorHandler.mineralList.remove(mix);
            }
        }
        for (IOre ore : GeolosysAPI.oreBlocks) {
            if (ore instanceof DepositMultiOre) {
                DepositMultiOre tmp = (DepositMultiOre)ore;
                String[] oreNames = new String[tmp.oreBlocks.size()];
                float[] oreChances = new float[tmp.oreBlocks.size()];
                int tally = 0;
                for (IBlockState state : tmp.oreBlocks.keySet()) {
                    ItemStack tempStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
                    String oreName = "depositOre" + tempStack.func_82833_r();
                    OreDictionary.registerOre((String)oreName, (ItemStack)tempStack);
                    oreNames[tally] = oreName;
                    oreChances[tally] = tmp.oreBlocks.get(state).intValue();
                    ++tally;
                }
                ExcavatorHandler.addMineral((String)ore.getFriendlyName(), (int)ore.getChance(), (float)0.05f, (String[])oreNames, (float[])oreChances);
                continue;
            }
            ItemStack tempStack = new ItemStack(ore.getOre().func_177230_c(), 1, ore.getOre().func_177230_c().func_176201_c(ore.getOre()));
            String oreName = "deposit" + tempStack.func_82833_r();
            ExcavatorHandler.addMineral((String)ore.getFriendlyName(), (int)ore.getChance(), (float)0.05f, (String[])new String[]{oreName}, (float[])new float[]{1.0f});
        }
    }

    private static void initCrusherCompat() {
        CrusherRecipe crusherRecipe = new CrusherRecipe(new ItemStack(Items.field_151044_h, 3, 0), (Object)new ItemStack((Block)Geolosys.getInstance().ORE_VANILLA, 1, 0), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151044_h), Float.valueOf(0.33f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151044_h), Float.valueOf(0.33f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151044_h), Float.valueOf(0.33f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151044_h), Float.valueOf(0.33f)});
        if (OreDictionary.doesOreNameExist((String)"dustSulfur") && OreDictionary.getOres((String)"dustSulfur").size() > 0) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{OreDictionary.getOres((String)"dustSulfur").get(0), Float.valueOf(0.02f)});
        }
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Items.field_151137_ax, 5), (Object)new ItemStack((Block)Geolosys.getInstance().ORE_VANILLA, 1, 1), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151137_ax), Float.valueOf(0.4f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151137_ax), Float.valueOf(0.4f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151137_ax), Float.valueOf(0.4f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151137_ax), Float.valueOf(0.4f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151137_ax), Float.valueOf(0.4f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151137_ax), Float.valueOf(0.4f)});
        if (ModMaterials.EXU_MATERIAL != null) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.EXU_MATERIAL), Float.valueOf(0.033f)});
        }
        if (ModMaterials.TE_MATERIAL != null) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.TE_MATERIAL, 1, 866), Float.valueOf(0.0166f)});
        }
        if (ModMaterials.NC_GEM != null) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.NC_GEM, 1, 0), Float.valueOf(0.25f)});
        }
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 1), (Object)new ItemStack((Block)Geolosys.getInstance().ORE_VANILLA, 1, 2), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Items.field_151100_aR, 6, 4), (Object)new ItemStack((Block)Geolosys.getInstance().ORE_VANILLA, 1, 3), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151100_aR, 1, 4), Float.valueOf(0.25f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151100_aR, 1, 4), Float.valueOf(0.25f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151100_aR, 1, 4), Float.valueOf(0.25f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151100_aR, 1, 4), Float.valueOf(0.25f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151100_aR, 1, 4), Float.valueOf(0.25f)});
        if (ModMaterials.NC_GEM != null) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.NC_GEM, 1, 2), Float.valueOf(0.95f)});
        }
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Items.field_151128_bU, 3, 0), (Object)new ItemStack((Block)Geolosys.getInstance().ORE_VANILLA, 1, 4), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151128_bU), Float.valueOf(0.2f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151128_bU), Float.valueOf(0.2f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151128_bU), Float.valueOf(0.2f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151128_bU), Float.valueOf(0.2f)});
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Items.field_151128_bU), Float.valueOf(0.2f)});
        if (ModConfig.compat.enableAE2Compat && ModMaterials.AE_MATERIAL != null) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.AE_MATERIAL, 1, 0), Float.valueOf(0.3f)});
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.AE_MATERIAL, 1, 1), Float.valueOf(0.12f)});
        }
        if (ModMaterials.BLACK_QUARTZ != null) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.BLACK_QUARTZ, 1, 5), Float.valueOf(0.32f)});
        }
        if (ModMaterials.NC_GEM != null) {
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(ModMaterials.NC_DUST, 1, 10), Float.valueOf(0.24f)});
        }
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Items.field_151045_i, 1, 0), (Object)new ItemStack((Block)Geolosys.getInstance().ORE_VANILLA, 1, 5), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Items.field_151166_bC, 1, 0), (Object)new ItemStack((Block)Geolosys.getInstance().ORE_VANILLA, 1, 6), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 0), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 0), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 0), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 1), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Geolosys.getInstance().CLUSTER, 1, 7), Float.valueOf(0.4f)});
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 2), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 2), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 2), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 3), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Geolosys.getInstance().CLUSTER, 1, 2), Float.valueOf(0.4f)});
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 3), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 4), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 3), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 5), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Geolosys.getInstance().CLUSTER, 1, 3), Float.valueOf(0.4f)});
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 4), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 6), 1000);
        crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Geolosys.getInstance().CLUSTER, 1, 5), Float.valueOf(1.0f)});
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 6), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 7), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
        if (ModConfig.compat.enableOsmiumExclusively) {
            crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 12), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 8), 1000);
        } else if (ModConfig.compat.enableOsmium) {
            crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 8), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 8), 1000);
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Geolosys.getInstance().CLUSTER, 1, 12), Float.valueOf(1.0f)});
        } else {
            crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 8), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 8), 1000);
        }
        CrusherRecipe.recipeList.add(crusherRecipe);
        if (ModConfig.compat.enableYellorium) {
            crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 9), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 9), 1000);
            crusherRecipe = crusherRecipe.addToSecondaryOutput(new Object[]{new ItemStack(Geolosys.getInstance().CLUSTER, 1, 11), Float.valueOf(1.0f)});
        } else {
            crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 9), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 9), 1000);
        }
        CrusherRecipe.recipeList.add(crusherRecipe);
        crusherRecipe = new CrusherRecipe(new ItemStack(Geolosys.getInstance().CLUSTER, 1, 10), (Object)new ItemStack((Block)Geolosys.getInstance().ORE, 1, 10), 1000);
        CrusherRecipe.recipeList.add(crusherRecipe);
    }

    private static void initBlastCompat() {
        if (ModConfig.featureControl.enableCoals) {
            BlastFurnaceRecipe.blastFuels.add(new BlastFurnaceRecipe.BlastFurnaceFuel(new IngredientStack(new ItemStack(Geolosys.getInstance().COAL, 1, 3)), 2400));
            if (Geolosys.getInstance().COAL_COKE != null) {
                BlastFurnaceRecipe.blastFuels.add(new BlastFurnaceRecipe.BlastFurnaceFuel(new IngredientStack(new ItemStack(Geolosys.getInstance().COAL_COKE, 1, 0)), 1600));
                BlastFurnaceRecipe.blastFuels.add(new BlastFurnaceRecipe.BlastFurnaceFuel(new IngredientStack(new ItemStack(Geolosys.getInstance().COAL_COKE, 1, 1)), 2400));
            }
        }
    }

    private static void initCokeCompat() {
        if (ModConfig.featureControl.enableCoals && Geolosys.getInstance().COAL_COKE != null) {
            CokeOvenRecipe.addRecipe((ItemStack)new ItemStack(Geolosys.getInstance().COAL_COKE, 1, 0), (Object)new ItemStack(Geolosys.getInstance().COAL, 1, 1), (int)1500, (int)750);
            CokeOvenRecipe.addRecipe((ItemStack)new ItemStack(Geolosys.getInstance().COAL_COKE, 1, 1), (Object)new ItemStack(Geolosys.getInstance().COAL, 1, 2), (int)3000, (int)1000);
        }
    }
}

