/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.compat;

import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.util.GeolosysSaveData;
import com.oitsjustjose.geolosys.common.util.Utils;
import com.oitsjustjose.geolosys.compat.ModMaterials;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class OreConverter {
    @SubscribeEvent
    public void registerEvent(EntityEvent.EnteringChunk event) {
        if (!ModConfig.featureControl.retroReplace) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer) || event.getEntity() instanceof FakePlayer || event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (GeolosysAPI.hasChunkRegenned(new ChunkPos(event.getNewChunkX(), event.getNewChunkZ()), event.getEntity().func_130014_f_().field_73011_w.getDimension())) {
            return;
        }
        int x = event.getNewChunkX();
        int z = event.getNewChunkZ();
        this.convertChunk(event.getEntity().func_130014_f_(), event, x * 16, z * 16);
        this.convertChunk(event.getEntity().func_130014_f_(), event, (x + 1) * 16, z * 16);
        this.convertChunk(event.getEntity().func_130014_f_(), event, (x - 1) * 16, z * 16);
        this.convertChunk(event.getEntity().func_130014_f_(), event, x * 16, (z + 1) * 16);
        this.convertChunk(event.getEntity().func_130014_f_(), event, x * 16, (z - 1) * 16);
        GeolosysSaveData.get(event.getEntity().func_130014_f_()).func_76185_a();
    }

    private void convertChunk(World world, EntityEvent.EnteringChunk event, int x, int z) {
        for (int xMod = 0; xMod < 16; ++xMod) {
            for (int zMod = 0; zMod < 16; ++zMod) {
                for (int y = 0; y < world.func_189649_b(x + xMod, z + zMod); ++y) {
                    if (GeolosysAPI.oreConverterBlacklist.contains(world.func_180495_p(new BlockPos(x + xMod, y, z + zMod))) || this.getConvertedOre(Utils.blockStateToStack(world.func_180495_p(new BlockPos(x + xMod, y, z + zMod)))) == null) continue;
                    world.func_175656_a(new BlockPos(x + xMod, y, z + zMod), Objects.requireNonNull(this.getConvertedOre(Utils.blockStateToStack(world.func_180495_p(new BlockPos(x + xMod, y, z + zMod))))));
                }
            }
        }
        GeolosysAPI.markChunkRegenned(new ChunkPos(event.getNewChunkX(), event.getNewChunkZ()), world.field_73011_w.getDimension());
    }

    private IBlockState getConvertedOre(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!ModMaterials.blockConverter.containsKey(OreDictionary.getOreName((int)id))) continue;
            return ModMaterials.blockConverter.get(OreDictionary.getOreName((int)id));
        }
        return null;
    }
}

