/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.compat.crafttweaker;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="crafttweaker")
@ZenRegister
@ZenClass(value="mods.geolosys.ores")
public class CraftTweakerOres {
    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState oreBlock, crafttweaker.api.block.IBlockState sampleBlock, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist) {
        if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made ore block");
        } else if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made sample block");
        } else {
            GeolosysAPI.registerMineralDeposit(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock), yMin, yMax, size, chance, dimBlacklist, null, density);
        }
    }

    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState oreBlock, crafttweaker.api.block.IBlockState sampleBlock, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist, crafttweaker.api.block.IBlockState[] blockStateMatchers) {
        ArrayList<IBlockState> toMCStates = new ArrayList<IBlockState>();
        for (crafttweaker.api.block.IBlockState state : blockStateMatchers) {
            if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state) == null) {
                Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made blockStateMatcher. It has been skipped but the rest of the array has not been.");
            }
            toMCStates.add(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state));
        }
        if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made ore block");
        } else if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made sample block");
        } else {
            GeolosysAPI.registerMineralDeposit(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock), yMin, yMax, size, chance, dimBlacklist, toMCStates, density);
        }
    }

    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState oreBlock, crafttweaker.api.block.IBlockState sampleBlock, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist, String[] biomes, boolean isWhitelist) {
        ArrayList<Biome> toMCBiomes = new ArrayList<Biome>();
        ArrayList<BiomeDictionary.Type> toMCBiomeTypes = new ArrayList<BiomeDictionary.Type>();
        for (String biome : biomes) {
            Biome b = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biome));
            if (b == null) {
                boolean found = false;
                for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
                    if (!type.getName().equalsIgnoreCase(biome)) continue;
                    found = true;
                    toMCBiomeTypes.add(type);
                    break;
                }
                if (found) continue;
                Geolosys.getInstance().LOGGER.info("The biome name " + biome + " does not seem to exist. Try finding it using /ct biomes in game");
                continue;
            }
            toMCBiomes.add(b);
        }
        if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made ore block");
        } else if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made sample block");
        } else {
            GeolosysAPI.registerMineralDeposit(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock), yMin, yMax, size, chance, dimBlacklist, null, toMCBiomes, toMCBiomeTypes, isWhitelist, density);
        }
    }

    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState oreBlock, crafttweaker.api.block.IBlockState sampleBlock, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist, String[] biomes, boolean isWhitelist, crafttweaker.api.block.IBlockState[] blockStateMatchers) {
        ArrayList<IBlockState> toMCStates = new ArrayList<IBlockState>();
        ArrayList<Biome> toMCBiomes = new ArrayList<Biome>();
        ArrayList<BiomeDictionary.Type> toMCBiomeTypes = new ArrayList<BiomeDictionary.Type>();
        for (crafttweaker.api.block.IBlockState iBlockState : blockStateMatchers) {
            if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)iBlockState) == null) {
                Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made blockStateMatcher. It has been skipped but the rest of the array has not been.");
            }
            toMCStates.add(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)iBlockState));
        }
        for (String string : biomes) {
            Biome b = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(string));
            if (b == null) {
                boolean found = false;
                for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
                    if (!type.getName().equalsIgnoreCase(string)) continue;
                    found = true;
                    toMCBiomeTypes.add(type);
                    break;
                }
                if (found) continue;
                Geolosys.getInstance().LOGGER.info("The biome name " + string + " does not seem to exist. Try finding it using /ct biomes in game");
                continue;
            }
            toMCBiomes.add(b);
        }
        Geolosys.getInstance().LOGGER.info(toMCBiomes);
        if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made ore block");
        } else if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock) == null) {
            Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made sample block");
        } else {
            GeolosysAPI.registerMineralDeposit(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlock), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlock), yMin, yMax, size, chance, dimBlacklist, toMCStates, toMCBiomes, toMCBiomeTypes, isWhitelist, density);
        }
    }

    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState[] oreBlocks, int[] oreBlockChances, crafttweaker.api.block.IBlockState[] sampleBlocks, int[] sampleBlockChances, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist) {
        int i;
        HashMap<IBlockState, Integer> oreBlockMap = new HashMap<IBlockState, Integer>();
        HashMap<IBlockState, Integer> sampleBlockMap = new HashMap<IBlockState, Integer>();
        if (oreBlockChances.length != oreBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of oreBlocks to oreBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        if (sampleBlockChances.length != sampleBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of sampleBlocks to sampleBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            oreBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlocks[i]), oreBlockChances[i]);
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            sampleBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlocks[i]), sampleBlockChances[i]);
        }
        GeolosysAPI.registerMineralDeposit(oreBlockMap, sampleBlockMap, yMin, yMax, size, chance, dimBlacklist, null, density);
    }

    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState[] oreBlocks, int[] oreBlockChances, crafttweaker.api.block.IBlockState[] sampleBlocks, int[] sampleBlockChances, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist, crafttweaker.api.block.IBlockState[] blockStateMatchers) {
        int i;
        ArrayList<IBlockState> toMCStates = new ArrayList<IBlockState>();
        for (crafttweaker.api.block.IBlockState state : blockStateMatchers) {
            if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state) == null) {
                Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made blockStateMatcher. It has been skipped but the rest of the array has not been.");
            }
            toMCStates.add(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state));
        }
        HashMap<IBlockState, Integer> oreBlockMap = new HashMap<IBlockState, Integer>();
        HashMap<IBlockState, Integer> sampleBlockMap = new HashMap<IBlockState, Integer>();
        if (oreBlockChances.length != oreBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of oreBlocks to oreBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        if (sampleBlockChances.length != sampleBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of sampleBlocks to sampleBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            oreBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlocks[i]), oreBlockChances[i]);
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            sampleBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlocks[i]), sampleBlockChances[i]);
        }
        GeolosysAPI.registerMineralDeposit(oreBlockMap, sampleBlockMap, yMin, yMax, size, chance, dimBlacklist, toMCStates, density);
    }

    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState[] oreBlocks, int[] oreBlockChances, crafttweaker.api.block.IBlockState[] sampleBlocks, int[] sampleBlockChances, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist, String[] biomes, boolean isWhitelist) {
        int i;
        ArrayList<Biome> toMCBiomes = new ArrayList<Biome>();
        ArrayList<BiomeDictionary.Type> toMCBiomeTypes = new ArrayList<BiomeDictionary.Type>();
        for (String biome : biomes) {
            Biome b = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biome));
            if (b == null) {
                boolean found = false;
                for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
                    if (!type.getName().equalsIgnoreCase(biome)) continue;
                    found = true;
                    toMCBiomeTypes.add(type);
                    break;
                }
                if (found) continue;
                Geolosys.getInstance().LOGGER.info("The biome name " + biome + " does not seem to exist. Try finding it using /ct biomes in game");
                continue;
            }
            toMCBiomes.add(b);
        }
        HashMap<IBlockState, Integer> oreBlockMap = new HashMap<IBlockState, Integer>();
        HashMap<IBlockState, Integer> sampleBlockMap = new HashMap<IBlockState, Integer>();
        if (oreBlockChances.length != oreBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of oreBlocks to oreBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        if (sampleBlockChances.length != sampleBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of sampleBlocks to sampleBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            oreBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlocks[i]), oreBlockChances[i]);
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            sampleBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlocks[i]), sampleBlockChances[i]);
        }
        GeolosysAPI.registerMineralDeposit(oreBlockMap, sampleBlockMap, yMin, yMax, size, chance, dimBlacklist, null, toMCBiomes, toMCBiomeTypes, isWhitelist, density);
    }

    @ZenMethod
    public static void addOre(crafttweaker.api.block.IBlockState[] oreBlocks, int[] oreBlockChances, crafttweaker.api.block.IBlockState[] sampleBlocks, int[] sampleBlockChances, int yMin, int yMax, int size, int chance, float density, int[] dimBlacklist, String[] biomes, boolean isWhitelist, crafttweaker.api.block.IBlockState[] blockStateMatchers) {
        int i;
        ArrayList<Biome> toMCBiomes = new ArrayList<Biome>();
        ArrayList<BiomeDictionary.Type> toMCBiomeTypes = new ArrayList<BiomeDictionary.Type>();
        for (String biome : biomes) {
            Biome b = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biome));
            if (b == null) {
                boolean found = false;
                for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
                    if (!type.getName().equalsIgnoreCase(biome)) continue;
                    found = true;
                    toMCBiomeTypes.add(type);
                    break;
                }
                if (found) continue;
                Geolosys.getInstance().LOGGER.info("The biome name " + biome + " does not seem to exist. Try finding it using /ct biomes in game");
                continue;
            }
            toMCBiomes.add(b);
        }
        ArrayList<IBlockState> toMCStates = new ArrayList<IBlockState>();
        for (crafttweaker.api.block.IBlockState state : blockStateMatchers) {
            if (CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state) == null) {
                Geolosys.getInstance().LOGGER.info("There was an error parsing a CraftTweaker-made blockStateMatcher. It has been skipped but the rest of the array has not been.");
            }
            toMCStates.add(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state));
        }
        HashMap<IBlockState, Integer> oreBlockMap = new HashMap<IBlockState, Integer>();
        HashMap<IBlockState, Integer> sampleBlockMap = new HashMap<IBlockState, Integer>();
        if (oreBlockChances.length != oreBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of oreBlocks to oreBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        if (sampleBlockChances.length != sampleBlocks.length) {
            Geolosys.getInstance().LOGGER.info("The length of sampleBlocks to sampleBlockChances were not the same. They MUST be the same. This entry has been skipped");
            return;
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            oreBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)oreBlocks[i]), oreBlockChances[i]);
        }
        for (i = 0; i < oreBlocks.length; ++i) {
            sampleBlockMap.put(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)sampleBlocks[i]), sampleBlockChances[i]);
        }
        GeolosysAPI.registerMineralDeposit(oreBlockMap, sampleBlockMap, yMin, yMax, size, chance, dimBlacklist, toMCStates, toMCBiomes, toMCBiomeTypes, isWhitelist, density);
    }
}

