/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.client.ClientProxy;
import com.oitsjustjose.geolosys.common.CommonProxy;
import com.oitsjustjose.geolosys.common.blocks.BlockInit;
import com.oitsjustjose.geolosys.common.config.ClientConfig;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.config.OreConfig;
import com.oitsjustjose.geolosys.common.event.ManualGifting;
import com.oitsjustjose.geolosys.common.items.ItemInit;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.FeatureStripper;
import com.oitsjustjose.geolosys.common.world.capability.GeolosysCapProvider;
import com.oitsjustjose.geolosys.common.world.capability.GeolosysCapStorage;
import com.oitsjustjose.geolosys.common.world.capability.GeolosysCapability;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import java.io.File;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="geolosys")
public class Geolosys {
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static Geolosys instance;
    public Logger LOGGER = LogManager.getLogger();

    public Geolosys() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ManualGifting());
        this.configSetup();
    }

    public static Geolosys getInstance() {
        return instance;
    }

    private void configSetup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfig.COMMON_CONFIG);
        CommonConfig.loadConfig(CommonConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("geolosys-common.toml"));
    }

    public void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IGeolosysCapability.class, (Capability.IStorage)new GeolosysCapStorage(), GeolosysCapability::new);
        if (((Boolean)CommonConfig.DISABLE_VANILLA_ORE_GEN.get()).booleanValue()) {
            DeferredWorkQueue.runLater(FeatureStripper::strip);
        }
        OreConfig.setup(new File("./config"));
        OreConfig.getInstance().init();
        GeolosysAPI.plutonRegistry.registerAsOreGenerator();
        proxy.init();
    }

    @SubscribeEvent
    public void attachCap(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("geolosys", "pluton"), (ICapabilityProvider)new GeolosysCapProvider());
        this.LOGGER.info("Geolosys capability attached for " + Utils.dimensionToString(((World)event.getObject()).func_201675_m()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onHover(ItemTooltipEvent event) {
        Collection tags;
        if (!((Boolean)ClientConfig.ENABLE_TAG_DEBUG.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_82882_x && (tags = ItemTags.func_199903_a().func_199913_a((Object)event.getItemStack().func_77973_b())).size() > 0) {
            for (ResourceLocation tag : tags) {
                event.getToolTip().add(new StringTextComponent("\u00a78#" + tag.toString() + "\u00a7r"));
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            BlockInit.getInstance().registerBlocks(blockRegistryEvent);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            BlockInit.getInstance().registerBlockItems(itemRegistryEvent);
            ItemInit.getInstance().register(itemRegistryEvent);
        }
    }
}

