/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;

public class DepositMultiOre
implements IDeposit {
    private ArrayList<BlockState> ores = new ArrayList();
    private ArrayList<BlockState> samples = new ArrayList();
    public HashMap<BlockState, Integer> oreBlocks;
    public HashMap<BlockState, Integer> sampleBlocks;
    private int yMin;
    private int yMax;
    private int size;
    private int chance;
    private String[] dimensionBlacklist;
    private List<BlockState> blockStateMatchers;
    private PlutonType type;
    private float density;

    public DepositMultiOre(HashMap<BlockState, Integer> oreBlocks, HashMap<BlockState, Integer> sampleBlocks, int yMin, int yMax, int size, int chance, String[] dimensionBlacklist, List<BlockState> blockStateMatchers, PlutonType type, float density) {
        int i;
        int sum = 0;
        for (BlockState key : oreBlocks.keySet()) {
            sum += oreBlocks.get(key).intValue();
        }
        assert (sum == 100) : "Sums of chances should equal 100";
        sum = 0;
        for (BlockState key : sampleBlocks.keySet()) {
            sum += sampleBlocks.get(key).intValue();
        }
        assert (sum == 100) : "Sums of chances should equal 100";
        int last = 0;
        for (BlockState key : oreBlocks.keySet()) {
            for (i = last; i < last + oreBlocks.get(key); ++i) {
                this.ores.add(i, key);
            }
            last += oreBlocks.get(key).intValue();
        }
        last = 0;
        for (BlockState key : sampleBlocks.keySet()) {
            for (i = last; i < last + sampleBlocks.get(key); ++i) {
                this.samples.add(i, key);
            }
            last += sampleBlocks.get(key).intValue();
        }
        this.oreBlocks = (HashMap)oreBlocks.clone();
        this.sampleBlocks = (HashMap)sampleBlocks.clone();
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.chance = chance;
        this.dimensionBlacklist = dimensionBlacklist;
        this.blockStateMatchers = blockStateMatchers;
        this.type = type;
        this.density = density;
    }

    public ArrayList<BlockState> getOres() {
        return this.ores;
    }

    public ArrayList<BlockState> getSamples() {
        return this.samples;
    }

    @Override
    public BlockState getOre() {
        BlockState backup = null;
        try {
            return this.ores.get(new Random().nextInt(100));
        }
        catch (IndexOutOfBoundsException e) {
            block2: {
                BlockState s;
                Iterator<BlockState> iterator = this.oreBlocks.keySet().iterator();
                if (!iterator.hasNext()) break block2;
                backup = s = iterator.next();
            }
            return backup;
        }
    }

    @Override
    public BlockState getSample() {
        BlockState backup = null;
        try {
            return this.samples.get(new Random().nextInt(100));
        }
        catch (IndexOutOfBoundsException e) {
            block2: {
                BlockState s;
                Iterator<BlockState> iterator = this.sampleBlocks.keySet().iterator();
                if (!iterator.hasNext()) break block2;
                backup = s = iterator.next();
            }
            return backup;
        }
    }

    @Override
    public String getFriendlyName() {
        StringBuilder sb = new StringBuilder();
        for (BlockState state : this.oreBlocks.keySet()) {
            String name = Utils.blockStateToName(state);
            if (sb.indexOf(name) != -1) continue;
            sb.append(" & ");
            sb.append(name);
        }
        return sb.toString().substring(3);
    }

    @Override
    public int getYMin() {
        return this.yMin;
    }

    @Override
    public int getYMax() {
        return this.yMax;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String[] getDimensionBlacklist() {
        return this.dimensionBlacklist;
    }

    @Override
    public boolean canReplace(BlockState state) {
        if (this.blockStateMatchers == null) {
            return true;
        }
        for (BlockState s : this.blockStateMatchers) {
            if (s != state) continue;
            return true;
        }
        return this.blockStateMatchers.contains(state);
    }

    @Override
    public List<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers;
    }

    public boolean oreMatches(ArrayList<BlockState> other) {
        for (BlockState state1 : this.oreBlocks.keySet()) {
            boolean isMatchInOtherArrayList = false;
            for (BlockState state2 : other) {
                if (!Utils.doStatesMatch(state1, state2)) continue;
                isMatchInOtherArrayList = true;
                break;
            }
            if (isMatchInOtherArrayList) continue;
            return false;
        }
        return this.oreBlocks.size() == other.size();
    }

    public boolean sampleMatches(ArrayList<BlockState> other) {
        for (BlockState state1 : this.sampleBlocks.keySet()) {
            boolean isMatchInOtherArrayList = false;
            for (BlockState state2 : other) {
                if (!Utils.doStatesMatch(state1, state2)) continue;
                isMatchInOtherArrayList = true;
                break;
            }
            if (isMatchInOtherArrayList) continue;
            return false;
        }
        return this.sampleBlocks.size() == other.size();
    }

    @Override
    public boolean oreMatches(BlockState other) {
        for (BlockState s : this.ores) {
            if (!Utils.doStatesMatch(s, other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean sampleMatches(BlockState other) {
        for (BlockState s : this.samples) {
            if (!Utils.doStatesMatch(s, other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PlutonType getPlutonType() {
        return this.type;
    }

    @Override
    public float getDensity() {
        return this.density;
    }
}

