/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.DepositMultiOre;
import com.oitsjustjose.geolosys.common.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class DepositMultiOreBiomeRestricted
extends DepositMultiOre {
    private List<Biome> biomes;
    private List<BiomeDictionary.Type> biomeTypes;
    private boolean useWhitelist;

    public DepositMultiOreBiomeRestricted(HashMap<BlockState, Integer> oreBlocks, HashMap<BlockState, Integer> sampleBlocks, int yMin, int yMax, int size, int chance, String[] dimensionBlacklist, List<BlockState> blockStateMatchers, List<Biome> biomes, List<BiomeDictionary.Type> biomeTypes, boolean useWhitelist, PlutonType type, float density) {
        super(oreBlocks, sampleBlocks, yMin, yMax, size, chance, dimensionBlacklist, blockStateMatchers, type, density);
        this.biomes = biomes;
        this.biomeTypes = biomeTypes;
        this.useWhitelist = useWhitelist;
    }

    public boolean canPlaceInBiome(Biome biome) {
        for (Biome b : this.biomes) {
            if (b != biome) continue;
            return true;
        }
        for (BiomeDictionary.Type type : this.biomeTypes) {
            Set dictTypes = BiomeDictionary.getTypes((Biome)biome);
            for (BiomeDictionary.Type otherType : dictTypes) {
                if (!type.getName().equalsIgnoreCase(otherType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getFriendlyName() {
        StringBuilder sb = new StringBuilder();
        for (BlockState state : this.oreBlocks.keySet()) {
            String name = Utils.blockStateToName(state);
            if (sb.indexOf(name) != -1) continue;
            sb.append(" & ");
            sb.append(name);
        }
        return sb.toString().substring(3);
    }

    public boolean useWhitelist() {
        return this.useWhitelist;
    }

    public boolean useBlacklist() {
        return !this.useWhitelist;
    }

    public List<Biome> getBiomeList() {
        return this.biomes;
    }

    public List<BiomeDictionary.Type> getBiomeTypes() {
        return this.biomeTypes;
    }
}

