/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketStackUnderground {
    public ItemStack stack;
    public String direction;

    public PacketStackUnderground(PacketBuffer buf) {
        this.stack = buf.func_150791_c();
        this.direction = buf.func_218666_n();
    }

    public PacketStackUnderground(ItemStack d1, String d2) {
        this.stack = d1;
        this.direction = d2;
    }

    public static PacketStackUnderground decode(PacketBuffer buf) {
        return new PacketStackUnderground(buf);
    }

    public static void encode(PacketStackUnderground msg, PacketBuffer buf) {
        buf.func_150788_a(msg.stack);
        buf.func_180714_a(msg.direction);
    }

    public void handleServer(Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(PacketStackUnderground msg, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.get().enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                PacketStackUnderground.sendProspectingMessage((PlayerEntity)mc.field_71439_g, msg.stack.func_200301_q(), msg.direction);
            });
        }
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendProspectingMessage(PlayerEntity player, Object ... messageDecorators) {
        TranslationTextComponent msg = new TranslationTextComponent("geolosys.pro_pick.tooltip.found", messageDecorators);
        player.func_146105_b((ITextComponent)msg, true);
    }
}

