/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api;

import java.io.Serializable;
import net.minecraft.util.math.BlockPos;

public class BlockPosDim
implements Serializable {
    private static final long serialVersionUID = 6006452707959283295L;
    private int x;
    private int y;
    private int z;
    private String dim;

    public BlockPosDim(BlockPos pos, String dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public BlockPosDim(int x, int y, int z, String dim) {
        this.x = x;
        this.z = z;
        this.dim = dim;
    }

    public BlockPosDim(String asString) {
        String[] parts = asString.replace("[", "").replace("]", "").split(",");
        assert (parts.length == 4);
        this.x = Integer.parseInt(parts[0]);
        this.y = Integer.parseInt(parts[1]);
        this.z = Integer.parseInt(parts[2]);
        this.dim = parts[3];
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getDimension() {
        return this.dim;
    }

    public String toString() {
        return "[" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getDimension() + "]";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof BlockPosDim) {
            BlockPosDim b = (BlockPosDim)other;
            return b.getX() == this.getX() && b.getY() == this.getY() && b.getZ() == this.getZ() && b.getDimension().equalsIgnoreCase(this.getDimension());
        }
        return false;
    }
}

