/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.utils.Utils;
import java.util.List;
import net.minecraft.block.BlockState;

public class DepositStone
implements IDeposit {
    private BlockState block;
    private int yMin;
    private int yMax;
    private int chance;
    private int size;
    private String[] dimBlacklist;

    public DepositStone(BlockState stoneBlock, int yMin, int yMax, int chance, int size, String[] dimBlacklist) {
        this.block = stoneBlock;
        this.yMin = yMin;
        this.yMax = yMax;
        this.chance = chance;
        this.size = size;
        this.dimBlacklist = dimBlacklist;
    }

    @Override
    public String[] getDimensionBlacklist() {
        return this.dimBlacklist;
    }

    @Override
    public BlockState getOre() {
        return this.block;
    }

    @Override
    public BlockState getSample() {
        return null;
    }

    @Override
    public int getYMin() {
        return this.yMin;
    }

    @Override
    public int getYMax() {
        return this.yMax;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean canReplace(BlockState state) {
        for (BlockState s : Utils.getDefaultMatchers()) {
            if (!Utils.doStatesMatch(state, s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BlockState> getBlockStateMatchers() {
        return null;
    }

    @Override
    public boolean oreMatches(BlockState other) {
        return Utils.doStatesMatch(other, this.block);
    }

    @Override
    public boolean sampleMatches(BlockState other) {
        return true;
    }

    @Override
    public float getDensity() {
        return 1.0f;
    }

    @Override
    public PlutonType getPlutonType() {
        return PlutonType.DENSE;
    }

    @Override
    public String getFriendlyName() {
        return Utils.blockStateToName(this.getOre());
    }
}

