/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import com.google.common.collect.Maps;
import com.oitsjustjose.geolosys.common.blocks.OreBlock;
import com.oitsjustjose.geolosys.common.blocks.SampleBlock;
import com.oitsjustjose.geolosys.common.blocks.Types;
import com.oitsjustjose.geolosys.common.utils.GeolosysGroup;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockInit {
    private static BlockInit instance;
    private HashMap<String, Block> blocks = Maps.newHashMap();

    private BlockInit() {
        Block sample;
        Block block;
        Block.Properties blockProp;
        for (Types.Vanilla vanilla : Types.Vanilla.values()) {
            blockProp = vanilla.getVanillaParent() != null ? Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(7.5f, 10.0f).func_200947_a(SoundType.field_185851_d).harvestLevel(vanilla.getToolLevel()).harvestTool(ToolType.PICKAXE).func_222379_b(vanilla.getVanillaParent()) : Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(7.5f, 10.0f).func_200947_a(SoundType.field_185851_d).harvestLevel(vanilla.getToolLevel()).harvestTool(ToolType.PICKAXE);
            block = (Block)new OreBlock(vanilla.getVanillaParent(), blockProp).setRegistryName("geolosys", vanilla.func_176610_l() + "_ore");
            this.blocks.put(block.getRegistryName().toString(), block);
            sample = vanilla.getVanillaParent() != null ? (Block)new SampleBlock().setRegistryName("geolosys", vanilla.func_176610_l() + "_ore_sample") : (Block)new SampleBlock(block).setRegistryName("geolosys", vanilla.func_176610_l() + "_ore_sample");
            this.blocks.put(sample.getRegistryName().toString(), sample);
        }
        for (Enum enum_ : Types.Modded.values()) {
            blockProp = Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(7.5f, 10.0f).func_200947_a(SoundType.field_185851_d).harvestLevel(((Types.Modded)enum_).getToolLevel()).harvestTool(ToolType.PICKAXE);
            block = (Block)new Block(blockProp).setRegistryName("geolosys", ((Types.Modded)enum_).func_176610_l() + "_ore");
            this.blocks.put(block.getRegistryName().toString(), block);
            sample = (Block)new SampleBlock(block).setRegistryName("geolosys", ((Types.Modded)enum_).func_176610_l() + "_ore_sample");
            this.blocks.put(sample.getRegistryName().toString(), sample);
        }
    }

    public static BlockInit getInstance() {
        if (instance == null) {
            instance = new BlockInit();
        }
        return instance;
    }

    public void registerBlocks(RegistryEvent.Register<Block> blockRegistryEvent) {
        for (Block b : this.getModBlocks().values()) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    public void registerBlockItems(RegistryEvent.Register<Item> itemRegistryEvent) {
        for (Block b : this.getModBlocks().values()) {
            Item iBlock = (Item)new BlockItem(b, new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance())).setRegistryName(b.getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
        }
    }

    public HashMap<String, Block> getModBlocks() {
        return (HashMap)this.blocks.clone();
    }
}

