/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class SampleUtils {
    private static ArrayList<BlockState> samplePlacementBlacklist = new ArrayList();
    private static Random random = new Random();

    @Nullable
    public static BlockPos getSamplePosition(IWorld world, ChunkPos chunkPos, int depositHeight) {
        int blockPosX = (chunkPos.field_77276_a << 4) + random.nextInt(16);
        int blockPosZ = (chunkPos.field_77275_b << 4) + random.nextInt(16);
        BlockPos searchPos = new BlockPos(blockPosX, 0, blockPosZ);
        while (searchPos.func_177956_o() < world.func_217301_I()) {
            world.func_180495_p(searchPos.func_177977_b()).func_177230_c();
            if (Block.func_220055_a((IWorldReader)world, (BlockPos)searchPos.func_177977_b(), (Direction)Direction.UP) && SampleUtils.canReplace(world, searchPos) && SampleUtils.canReplace(world, searchPos.func_177984_a()) && SampleUtils.canPlaceOn(world, searchPos)) {
                if (searchPos.func_177956_o() > world.func_181545_F()) {
                    return searchPos;
                }
                if (SampleUtils.isWithinRange(world.func_181545_F(), searchPos.func_177956_o(), 12) && searchPos.func_177956_o() < depositHeight) {
                    return searchPos;
                }
            }
            searchPos = searchPos.func_177984_a();
        }
        return null;
    }

    public static boolean canPlaceOn(IWorld world, BlockPos pos) {
        return !samplePlacementBlacklist.contains(world.func_180495_p(pos.func_177977_b())) && Block.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public static boolean canReplace(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Material mat = state.func_185904_a();
        return state.isFoliage((IWorldReader)world, pos) || mat.func_76222_j();
    }

    public static int getSampleCount(IDeposit ore) {
        int count = ore.getSize() / (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get() + ore.getSize() % (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get();
        return Math.min((Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get(), count);
    }

    public static boolean isInWater(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
    }

    public static boolean inNonWaterFluid(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76224_d() && !SampleUtils.isInWater(world, pos);
    }

    public static boolean isWithinRange(int posA, int posB, int range) {
        return Math.abs(posA - posB) <= range;
    }

    public static void addSamplePlacementBlacklist(Block block) {
        samplePlacementBlacklist.add(block.func_176223_P());
    }
}

