/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.BlockPosDim;
import com.oitsjustjose.geolosys.api.ChunkPosDim;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.blocks.SampleBlock;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PlutonOreFeature
extends Feature<NoFeatureConfig> {
    public PlutonOreFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    private void postPlacement(IWorld world, BlockPos plutonStartPos, IDeposit ore) {
        IGeolosysCapability plutonCapability;
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.debug("Generated " + ore.getOre().func_177230_c().getRegistryName().toString() + " in Chunk " + new ChunkPos(plutonStartPos));
        }
        if ((plutonCapability = (IGeolosysCapability)world.func_201672_e().getCapability(GeolosysAPI.GEOLOSYS_WORLD_CAPABILITY).orElse(null)) != null) {
            plutonCapability.setOrePlutonGenerated(new ChunkPosDim(plutonStartPos.func_177958_n(), plutonStartPos.func_177952_p(), Utils.dimensionToString(world.func_201675_m())));
        }
        if (world.func_201672_e().func_175624_G() != WorldType.field_77138_c) {
            int sampleLimit = SampleUtils.getSampleCount(ore);
            for (int i = 0; i < sampleLimit; ++i) {
                BlockPos samplePos = SampleUtils.getSamplePosition(world, new ChunkPos(plutonStartPos), ore.getYMax());
                if (samplePos == null || SampleUtils.inNonWaterFluid(world, samplePos) || world.func_180495_p(samplePos) == ore.getSample()) continue;
                boolean isInWater = SampleUtils.isInWater(world, samplePos);
                if (ore.getSample().func_177230_c() instanceof SampleBlock) {
                    BlockState sampleState = isInWater ? (BlockState)ore.getSample().func_206870_a((IProperty)SampleBlock.WATERLOGGED, (Comparable)Boolean.TRUE) : ore.getSample();
                    world.func_180501_a(samplePos, sampleState, 18);
                    continue;
                }
                if (isInWater && ore.getSample().func_177230_c() instanceof IWaterLoggable) {
                    world.func_180501_a(samplePos, (BlockState)ore.getSample().func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.TRUE), 18);
                    continue;
                }
                world.func_180501_a(samplePos, ore.getSample(), 18);
            }
        }
    }

    private boolean isInChunk(ChunkPos chunkPos, BlockPos pos) {
        int blockX = pos.func_177958_n();
        int blockZ = pos.func_177952_p();
        return blockX >= chunkPos.func_180334_c() && blockX <= chunkPos.func_180332_e() && blockZ >= chunkPos.func_180333_d() && blockZ <= chunkPos.func_180330_f();
    }

    private boolean isInChunk(ChunkPos chunkPos, BlockPosDim pos) {
        int blockX = pos.getX();
        int blockZ = pos.getZ();
        return blockX >= chunkPos.func_180334_c() && blockX <= chunkPos.func_180332_e() && blockZ >= chunkPos.func_180333_d() && blockZ <= chunkPos.func_180330_f();
    }

    @ParametersAreNonnullByDefault
    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        IDeposit restricted;
        IGeolosysCapability plutonCapability = (IGeolosysCapability)worldIn.func_201672_e().getCapability(GeolosysAPI.GEOLOSYS_WORLD_CAPABILITY).orElse(null);
        plutonCapability.getPendingBlocks().forEach((pPos, pState) -> {
            if (this.isInChunk(new ChunkPos(pos), (BlockPosDim)pPos)) {
                if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
                    Geolosys.getInstance().LOGGER.info("Generated pending block " + pState.func_177230_c().getRegistryName().toString() + " at " + pos);
                }
                worldIn.func_180501_a(pPos.getPos(), pState, 18);
                plutonCapability.getPendingBlocks().remove(pPos);
            }
        });
        ChunkPosDim chunkPosDim = new ChunkPosDim(pos, Utils.dimensionToString(worldIn.func_201675_m()));
        if (plutonCapability.hasOrePlutonGenerated(chunkPosDim)) {
            return false;
        }
        IDeposit pluton = GeolosysAPI.plutonRegistry.pickPluton(worldIn, pos, rand);
        if (pluton == null) {
            return false;
        }
        if (rand.nextInt(100) > pluton.getChance()) {
            return false;
        }
        if (pluton instanceof DepositBiomeRestricted ? !((DepositBiomeRestricted)(restricted = (DepositBiomeRestricted)pluton)).canPlaceInBiome(worldIn.func_226691_t_(pos)) : pluton instanceof DepositMultiOreBiomeRestricted && !((DepositMultiOreBiomeRestricted)(restricted = (DepositMultiOreBiomeRestricted)pluton)).canPlaceInBiome(worldIn.func_226691_t_(pos))) {
            return false;
        }
        List dimTypes = ((Stream)Arrays.stream(pluton.getDimensionBlacklist()).parallel()).map(x -> DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(x))).collect(Collectors.toList());
        if (dimTypes.contains(worldIn.func_201675_m().func_186058_p())) {
            return false;
        }
        boolean placed = false;
        if (pluton.getPlutonType() == PlutonType.DENSE) {
            placed = this.generateDense(worldIn, pos, rand, pluton, plutonCapability);
        } else if (pluton.getPlutonType() == PlutonType.SPARSE) {
            placed = this.generateSparse(worldIn, pos, rand, pluton, plutonCapability);
        } else if (pluton.getPlutonType() == PlutonType.DIKE) {
            placed = this.generateDike(worldIn, pos, rand, pluton, plutonCapability);
        } else if (pluton.getPlutonType() == PlutonType.LAYER) {
            placed = this.generateLayer(worldIn, pos, rand, pluton, plutonCapability);
        } else {
            Geolosys.getInstance().LOGGER.error("Unknown Generation Logic for PlutonType {}", (Object)pluton.getPlutonType());
        }
        if (placed) {
            this.postPlacement(worldIn, pos, pluton);
        }
        return placed;
    }

    private boolean generateLayer(IWorld worldIn, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        int x = (thisChunk.func_180334_c() + thisChunk.func_180332_e()) / 2 - rand.nextInt(8) + rand.nextInt(16);
        int y = pluton.getYMin() + rand.nextInt(Math.abs(pluton.getYMax() - pluton.getYMin()));
        int z = (thisChunk.func_180333_d() + thisChunk.func_180330_f()) / 2 - rand.nextInt(8) + rand.nextInt(16);
        BlockPos basePos = new BlockPos(x, y, z);
        int radius = pluton.getSize() / 2;
        int depth = rand.nextBoolean() ? 1 : 2;
        for (int dX = -radius; dX <= radius; ++dX) {
            for (int dZ = -radius; dZ <= radius; ++dZ) {
                block2: for (int dY = 0; dY < depth; ++dY) {
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)radius) continue;
                    BlockPos blockpos = basePos.func_177982_a(dX, dY, dZ);
                    if (this.isInChunk(thisChunk, blockpos) || worldIn.func_217354_b(x >> 4, z >> 4)) {
                        float density = Math.min(pluton.getDensity(), 1.0f);
                        if (rand.nextFloat() > density) continue;
                        BlockState state = worldIn.func_180495_p(blockpos);
                        for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                            if (!Utils.doStatesMatch(matcherState, state)) continue;
                            worldIn.func_180501_a(blockpos, pluton.getOre(), 18);
                            placed = true;
                            continue block2;
                        }
                        continue;
                    }
                    plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(worldIn.func_201675_m())), pluton.getOre());
                }
            }
        }
        return placed;
    }

    private boolean generateDike(IWorld worldIn, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        int height = Math.abs(pluton.getYMax() - pluton.getYMin());
        int x = thisChunk.func_180334_c() + rand.nextInt(16);
        int y = pluton.getYMin() + rand.nextInt(height);
        int z = thisChunk.func_180333_d() + rand.nextInt(16);
        BlockPos basePos = new BlockPos(x, y, z);
        int radius = pluton.getSize() / height > 0 ? pluton.getSize() / height : height / pluton.getSize();
        for (int dY = y; dY <= pluton.getYMax(); ++dY) {
            for (int dX = -radius; dX <= radius; ++dX) {
                block2: for (int dZ = -radius; dZ <= radius; ++dZ) {
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)radius) continue;
                    BlockPos blockpos = new BlockPos(basePos.func_177958_n() + dX, dY, basePos.func_177952_p() + dZ);
                    if (this.isInChunk(thisChunk, blockpos) || worldIn.func_217354_b(x >> 4, z >> 4)) {
                        float density = Math.min(pluton.getDensity(), 1.0f);
                        if (rand.nextFloat() > density) continue;
                        BlockState state = worldIn.func_180495_p(blockpos);
                        for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                            if (!Utils.doStatesMatch(matcherState, state)) continue;
                            worldIn.func_180501_a(blockpos, pluton.getOre(), 18);
                            placed = true;
                            continue block2;
                        }
                        continue;
                    }
                    plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(worldIn.func_201675_m())), pluton.getOre());
                    placed = true;
                }
            }
            if (rand.nextInt(100) % pluton.getSize() != 0 || --radius >= 0) continue;
            return placed;
        }
        return placed;
    }

    private boolean generateSparse(IWorld worldIn, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        for (int y = pluton.getYMin(); y < pluton.getYMax(); ++y) {
            int numAttempts = rand.nextInt(pluton.getSize() / 3);
            block1: for (int attempt = 0; attempt < numAttempts; ++attempt) {
                int z;
                int x = pos.func_177958_n() + rand.nextInt(16);
                BlockPos blockpos = new BlockPos(x, y, z = pos.func_177952_p() + rand.nextInt(16));
                if (this.isInChunk(thisChunk, blockpos) || worldIn.func_217354_b(x >> 4, z >> 4)) {
                    float density = Math.min(pluton.getDensity(), 1.0f);
                    if (rand.nextFloat() > density) continue;
                    BlockState state = worldIn.func_180495_p(blockpos);
                    for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                        if (!Utils.doStatesMatch(matcherState, state)) continue;
                        worldIn.func_180501_a(blockpos, pluton.getOre(), 18);
                        placed = true;
                        continue block1;
                    }
                    continue;
                }
                plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(worldIn.func_201675_m())), pluton.getOre());
            }
        }
        return placed;
    }

    private boolean generateDense(IWorld worldIn, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        int randY = pluton.getYMin() + rand.nextInt(pluton.getYMax() - pluton.getYMin());
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(pos.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)pluton.getSize() / 8.0f;
        double d1 = (float)(pos.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)pluton.getSize() / 8.0f;
        double d2 = (float)(pos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)pluton.getSize() / 8.0f;
        double d3 = (float)(pos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)pluton.getSize() / 8.0f;
        double d4 = randY + rand.nextInt(3) - 2;
        double d5 = randY + rand.nextInt(3) - 2;
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        for (int i = 0; i < pluton.getSize(); ++i) {
            float f1 = (float)i / (float)pluton.getSize();
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = rand.nextDouble() * (double)pluton.getSize() / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    block3: for (int j2 = l; j2 <= k1; ++j2) {
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        BlockPos blockpos = new BlockPos(l1, i2, j2);
                        if (this.isInChunk(thisChunk, blockpos) || worldIn.func_217354_b(l1 >> 4, j2 >> 4)) {
                            float density = Math.min(pluton.getDensity(), 1.0f);
                            if (rand.nextFloat() > density) continue;
                            BlockState state = worldIn.func_180495_p(blockpos);
                            for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                                if (!Utils.doStatesMatch(matcherState, state)) continue;
                                worldIn.func_180501_a(blockpos, pluton.getOre(), 18);
                                placed = true;
                                continue block3;
                            }
                            continue;
                        }
                        plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(worldIn.func_201675_m())), pluton.getOre());
                    }
                }
            }
        }
        return placed;
    }
}

