/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.LogHelper;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.module.dragon.phase.CrystalRespawnPhase;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@Label(name="Crystals", description="Makes more Crystal spawn and with more cages.")
public class CrystalFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> moreCagesAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxBonusCagesConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> moreCrystalsAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> moreCrystalsStepConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> moreCrystalsMaxConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> enableCrystalRespawnConfig;
    private final ForgeConfigSpec.ConfigValue<Double> crystalRespawnPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> explosionImmuneConfig;
    public int moreCagesAtDifficulty = 1;
    public int maxBonusCages = 6;
    public int moreCrystalsAtDifficulty = 2;
    public int moreCrystalsStep = 3;
    public int moreCrystalsMax = 3;
    public boolean enableCrystalRespawn = true;
    public double crystalRespawnPerDifficulty = 0.5;
    public boolean explosionImmune = true;
    private static final List<EnderDragonPhase<? extends DragonPhaseInstance>> VALID_CRYSTAL_RESPAWN_PHASES = Arrays.asList(EnderDragonPhase.f_31383_, EnderDragonPhase.f_31384_, EnderDragonPhase.f_31382_, EnderDragonPhase.f_31377_, EnderDragonPhase.f_31381_, EnderDragonPhase.f_31385_, EnderDragonPhase.f_31378_);
    private static final ResourceLocation ENDERGETIC_CRYSTAL_HOLDER_RL = new ResourceLocation("endergetic:crystal_holder");

    public CrystalFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.moreCagesAtDifficultyConfig = Config.builder.comment("At this difficulty cages will start to appear around other crystals too. -1 will disable this feature.").defineInRange("More Cages at Difficulty", this.moreCagesAtDifficulty, -1, Integer.MAX_VALUE);
        this.maxBonusCagesConfig = Config.builder.comment("Max number of bonus cages that can spawn around the crystals.").defineInRange("Max Bonus Cages", this.maxBonusCages, 0, 8);
        this.moreCrystalsAtDifficultyConfig = Config.builder.comment("At this difficulty one crystal will start to appear inside obsidian towers. -1 will disable this feature.").defineInRange("More Crystals at Difficulty", this.moreCrystalsAtDifficulty, -1, Integer.MAX_VALUE);
        this.moreCrystalsStepConfig = Config.builder.comment("Every how much difficulty one more crystal will be spawned inside towers").defineInRange("More Crystals Step", this.moreCrystalsStep, -1, Integer.MAX_VALUE);
        this.moreCrystalsMaxConfig = Config.builder.comment("Max number of bonus crystals that can spawn inside the towers.").defineInRange("More Crystals Max", this.moreCrystalsMax, 0, 10);
        this.enableCrystalRespawnConfig = Config.builder.comment("Everytime the dragon is hit (when below 50% of health) there's a chance to to trigger a Crystal respawn Phase. The chance is 0% when health >=50% and 100% when health <=30%, the health threshold decreases by 20% every time the dragon respawns crystals.").define("Enable crystal respawn", this.enableCrystalRespawn);
        this.crystalRespawnPerDifficultyConfig = Config.builder.comment("Difficulty multiplied by this number will output how many crystals will the dragon respawn.").defineInRange("Crystal Respawn Per Difficulty", this.crystalRespawnPerDifficulty, 0.0, 10.0);
        this.explosionImmuneConfig = Config.builder.comment("Crystals can no longer be destroyed by other explosions.").define("Explosion Immune", this.explosionImmune);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.moreCagesAtDifficulty = (Integer)this.moreCagesAtDifficultyConfig.get();
        this.maxBonusCages = (Integer)this.maxBonusCagesConfig.get();
        this.moreCrystalsAtDifficulty = (Integer)this.moreCrystalsAtDifficultyConfig.get();
        this.moreCrystalsStep = (Integer)this.moreCrystalsStepConfig.get();
        this.moreCrystalsMax = (Integer)this.moreCrystalsMaxConfig.get();
        this.enableCrystalRespawn = (Boolean)this.enableCrystalRespawnConfig.get();
        this.crystalRespawnPerDifficulty = (Double)this.crystalRespawnPerDifficultyConfig.get();
        this.explosionImmune = (Boolean)this.explosionImmuneConfig.get();
    }

    @SubscribeEvent
    public void onDragonDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        if (!this.enableCrystalRespawn) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        if (!VALID_CRYSTAL_RESPAWN_PHASES.contains(dragon.m_31157_().m_31415_().m_7309_())) {
            return;
        }
        float healthRatio = dragon.m_21223_() / dragon.m_21233_();
        if ((double)healthRatio >= 0.25) {
            return;
        }
        byte crystalRespawn = dragonTags.m_128445_("progressivebosses:crystal_respawn");
        float chance = this.getChanceAtValue(healthRatio, 0.8f - (float)crystalRespawn * 0.35f, 0.2f - (float)crystalRespawn * 0.35f);
        if (dragon.m_21187_().nextFloat() > chance) {
            return;
        }
        dragonTags.m_128344_("progressivebosses:crystal_respawn", (byte)(crystalRespawn + 1));
        double crystalsRespawned = Mth.m_14008_((double)((double)difficulty * this.crystalRespawnPerDifficulty), (double)0.0, (double)10.0);
        crystalsRespawned = Utils.getAmountWithDecimalChance(dragon.m_21187_(), crystalsRespawned);
        if (crystalsRespawned == 0.0) {
            return;
        }
        dragon.m_31157_().m_31416_(CrystalRespawnPhase.getPhaseType());
        CrystalRespawnPhase phase = (CrystalRespawnPhase)dragon.m_31157_().m_31415_();
        ArrayList<SpikeFeature.EndSpike> spikes = new ArrayList<SpikeFeature.EndSpike>(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)dragon.f_19853_)));
        spikes.sort(Comparator.comparingInt(SpikeFeature.EndSpike::m_66896_).reversed());
        int i = 0;
        while ((double)i < crystalsRespawned) {
            SpikeFeature.EndSpike targetSpike = (SpikeFeature.EndSpike)spikes.get(i);
            phase.addCrystalRespawn(targetSpike);
            ++i;
        }
    }

    private float getChanceAtValue(float value, float max, float min) {
        return Mth.m_14036_((float)((max - min - (value - min)) / (max - min)), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        this.crystalCages(dragon, difficulty);
        this.moreCrystals(dragon, difficulty);
    }

    private void crystalCages(EnderDragon dragon, float difficulty) {
        if (this.moreCagesAtDifficulty == -1 || this.maxBonusCages == 0) {
            return;
        }
        if (difficulty < (float)this.moreCagesAtDifficulty) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        if (dragonTags.m_128441_("progressivebosses:crystal_cages")) {
            return;
        }
        dragonTags.m_128379_("progressivebosses:crystal_cages", true);
        ArrayList<EndCrystal> crystals = new ArrayList<EndCrystal>();
        ArrayList<SpikeFeature.EndSpike> spikes = new ArrayList<SpikeFeature.EndSpike>(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)dragon.f_19853_)));
        spikes.sort(Comparator.comparingInt(SpikeFeature.EndSpike::m_66896_));
        for (SpikeFeature.EndSpike spike : spikes) {
            crystals.addAll(dragon.f_19853_.m_45976_(EndCrystal.class, spike.m_66905_()));
        }
        crystals.removeIf(c -> c.f_19853_.m_8055_(c.m_142538_().m_6630_(2)).m_60734_() == Blocks.f_50183_);
        int crystalsInvolved = Math.round(difficulty - (float)this.moreCagesAtDifficulty + 1.0f);
        int cagesGenerated = 0;
        for (EndCrystal crystal : crystals) {
            CrystalFeature.generateCage(crystal.f_19853_, crystal.m_142538_());
            if (++cagesGenerated != crystalsInvolved && cagesGenerated != this.maxBonusCages) continue;
            break;
        }
    }

    private void moreCrystals(EnderDragon dragon, float difficulty) {
        if (this.moreCrystalsAtDifficulty == -1 || this.moreCrystalsMax == 0) {
            return;
        }
        if (difficulty < (float)this.moreCrystalsAtDifficulty) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        if (dragonTags.m_128441_("progressivebosses:more_crystals")) {
            return;
        }
        dragonTags.m_128379_("progressivebosses:more_crystals", true);
        ArrayList crystals = new ArrayList();
        ArrayList<SpikeFeature.EndSpike> spikes = new ArrayList<SpikeFeature.EndSpike>(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)dragon.f_19853_)));
        spikes.sort(Comparator.comparingInt(SpikeFeature.EndSpike::m_66896_));
        for (SpikeFeature.EndSpike spike : spikes) {
            crystals.addAll(dragon.f_19853_.m_6443_(EndCrystal.class, spike.m_66905_(), EndCrystal::m_31065_));
        }
        int crystalsMax = (int)Math.ceil((difficulty + 1.0f - (float)this.moreCrystalsAtDifficulty) / (float)this.moreCrystalsStep);
        if (crystalsMax <= 0) {
            return;
        }
        int crystalSpawned = 0;
        for (EndCrystal crystal : crystals) {
            CrystalFeature.generateCrystalInTower(dragon.f_19853_, crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_());
            if (++crystalSpawned != crystalsMax && crystalSpawned != this.moreCrystalsMax) continue;
            break;
        }
    }

    public boolean onDamageFromExplosion(EndCrystal enderCrystalEntity, DamageSource source) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.explosionImmune) {
            return false;
        }
        return source.m_19372_();
    }

    public static EndCrystal generateCrystalInTower(Level world, double x, double y, double z) {
        Vec3 centerPodium = Vec3.m_82539_((Vec3i)world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_));
        int spawnY = (int)(y - (double)RandomHelper.getInt((Random)world.m_5822_(), (int)12, (int)24));
        if ((double)spawnY < centerPodium.m_7098_()) {
            spawnY = (int)centerPodium.m_7098_();
        }
        BlockPos crystalPos = new BlockPos(x, (double)spawnY, z);
        Stream blocks = BlockPos.m_121990_((BlockPos)crystalPos.m_142082_(-1, -1, -1), (BlockPos)crystalPos.m_142082_(1, 1, 1));
        blocks.forEach(pos -> world.m_46597_(pos, Blocks.f_50016_.m_49966_()));
        BlockState baseBlockState = Blocks.f_50752_.m_49966_();
        if (ModList.get().isLoaded("endergetic")) {
            if (ForgeRegistries.BLOCKS.containsKey(ENDERGETIC_CRYSTAL_HOLDER_RL)) {
                baseBlockState = ((Block)ForgeRegistries.BLOCKS.getValue(ENDERGETIC_CRYSTAL_HOLDER_RL)).m_49966_();
            } else {
                LogHelper.warn((String)"The Endergetic Expansion is loaded but the %s block was not registered", (Object[])new Object[]{ENDERGETIC_CRYSTAL_HOLDER_RL});
            }
        }
        world.m_46597_(crystalPos.m_142082_(0, -1, 0), baseBlockState);
        world.m_46511_(null, (double)((float)crystalPos.m_123341_() + 0.5f), (double)crystalPos.m_123342_(), (double)crystalPos.m_123343_() + 0.5, 5.0f, Explosion.BlockInteraction.DESTROY);
        EndCrystal crystal = new EndCrystal(world, (double)crystalPos.m_123341_() + 0.5, (double)crystalPos.m_123342_(), (double)crystalPos.m_123343_() + 0.5);
        world.m_7967_((Entity)crystal);
        return crystal;
    }

    public static void generateCage(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k = -2; k <= 2; ++k) {
            for (int l = -2; l <= 2; ++l) {
                for (int i1 = 0; i1 <= 3; ++i1) {
                    boolean flag2;
                    boolean flag = Mth.m_14040_((int)k) == 2;
                    boolean flag1 = Mth.m_14040_((int)l) == 2;
                    boolean bl = flag2 = i1 == 3;
                    if (!flag && !flag1 && !flag2) continue;
                    boolean flag3 = k == -2 || k == 2 || flag2;
                    boolean flag4 = l == -2 || l == 2 || flag2;
                    BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50183_.m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(flag3 && l != -2))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(flag3 && l != 2))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(flag4 && k != -2))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(flag4 && k != 2));
                    world.m_46597_((BlockPos)blockpos$mutable.m_122178_(pos.m_123341_() + k, pos.m_123342_() - 1 + i1, pos.m_123343_() + l), blockstate);
                }
            }
        }
    }
}

