/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import com.google.common.util.concurrent.AtomicDouble;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.LogHelper;
import insane96mcp.progressivebosses.capability.Difficulty;
import insane96mcp.progressivebosses.setup.Config;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Difficulty Settings", description="How difficulty is handled for the Dragon.")
public class DifficultyFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> sumKilledDragonDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusDifficultyPerPlayerConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> startingDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> showFirstKilledDragonMessageConfig;
    public boolean sumKilledDragonDifficulty = false;
    public double bonusDifficultyPerPlayer = 0.25;
    public int maxDifficulty = 8;
    public int startingDifficulty = 0;
    public boolean showFirstKilledDragonMessage = true;

    public DifficultyFeature(Module module) {
        super(Config.builder, module, true, false);
        this.pushConfig(Config.builder);
        this.sumKilledDragonDifficultyConfig = Config.builder.comment("If false and there's more than 1 player around the Dragon, difficulty will be the average of all the players' difficulty instead of summing them.").define("Sum Killed Dragons Difficulty", this.sumKilledDragonDifficulty);
        this.bonusDifficultyPerPlayerConfig = Config.builder.comment("Percentage bonus difficulty added to the Dragon when more than one player is present. Each player past the first one will add this percentage to the difficulty.").defineInRange("Bonus Difficulty per Player", this.bonusDifficultyPerPlayer, 0.0, 1.0);
        this.maxDifficultyConfig = Config.builder.comment("The Maximum difficulty (times killed) reachable by Ender Dragon. By default is set to 24 because it's the last spawning end gate.").defineInRange("Max Difficulty", this.maxDifficulty, 1, Integer.MAX_VALUE);
        this.startingDifficultyConfig = Config.builder.comment("How much difficulty will players start with when joining a world? Note that this will apply when the player joins the world if the current player difficulty is below this value.").defineInRange("Starting Difficulty", this.startingDifficulty, 0, Integer.MAX_VALUE);
        this.showFirstKilledDragonMessageConfig = Config.builder.comment("Set to false to disable the first Dragon killed message.").define("Show First Killed Dragon Message", this.showFirstKilledDragonMessage);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.sumKilledDragonDifficulty = (Boolean)this.sumKilledDragonDifficultyConfig.get();
        this.bonusDifficultyPerPlayer = (Double)this.bonusDifficultyPerPlayerConfig.get();
        this.maxDifficulty = (Integer)this.maxDifficultyConfig.get();
        this.startingDifficulty = (Integer)this.startingDifficultyConfig.get();
        this.showFirstKilledDragonMessage = (Boolean)this.showFirstKilledDragonMessageConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getWorld().m_46472_().m_135782_().equals((Object)DimensionType.f_63847_.m_135782_())) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        if (dragon.m_31158_() == null) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        if (dragonTags.m_128441_("progressivebosses:difficulty")) {
            return;
        }
        int radius = 256;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = event.getWorld().m_45976_(ServerPlayer.class, bb);
        if (players.size() == 0) {
            return;
        }
        AtomicInteger playersFirstDragon = new AtomicInteger(0);
        AtomicDouble dragonDifficulty = new AtomicDouble(0.0);
        for (ServerPlayer player : players) {
            player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
                dragonDifficulty.addAndGet((double)difficulty.getKilledDragons());
                if (difficulty.getFirstDragon() == 1) {
                    playersFirstDragon.incrementAndGet();
                    difficulty.setFirstDragon((byte)2);
                }
            });
        }
        dragonTags.m_128405_("progressivebosses:eggs_to_drop", playersFirstDragon.get());
        if (!this.sumKilledDragonDifficulty) {
            dragonDifficulty.set(dragonDifficulty.get() / (double)players.size());
        }
        if (players.size() > 1) {
            dragonDifficulty.set(dragonDifficulty.get() * (1.0 + (double)(players.size() - 1) * this.bonusDifficultyPerPlayer));
        }
        dragonTags.m_128350_("progressivebosses:difficulty", (float)dragonDifficulty.get());
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        int radius = 256;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = dragon.f_19853_.m_45976_(ServerPlayer.class, bb);
        if (players.size() == 0) {
            ServerPlayer nearestPlayer = (ServerPlayer)dragon.f_19853_.m_45924_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), Double.MAX_VALUE, true);
            players.add(nearestPlayer);
        }
        for (ServerPlayer player : players) {
            player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
                if (difficulty.getKilledDragons() <= this.startingDifficulty && this.showFirstKilledDragonMessage) {
                    player.m_6352_((Component)new TranslatableComponent("dragon.first_killed"), Util.f_137441_);
                }
                if (difficulty.getKilledDragons() < this.maxDifficulty) {
                    difficulty.addKilledDragons(1);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void setPlayerData(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
            if (difficulty.getKilledDragons() < this.startingDifficulty) {
                difficulty.setKilledDragons(this.startingDifficulty);
                LogHelper.info((String)"[Progressive Bosses] %s killed dragons counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", (Object[])new Object[]{player.m_7755_().getString()});
            }
            if (difficulty.getKilledDragons() > this.maxDifficulty) {
                difficulty.setKilledDragons(this.maxDifficulty);
                LogHelper.info((String)"[Progressive Bosses] %s killed dragons counter was above the 'Max Difficulty', Has been decreased to match 'Max Difficulty'", (Object[])new Object[]{player.m_7755_().getString()});
            }
            if (difficulty.getFirstDragon() == 0) {
                difficulty.setFirstDragon((byte)1);
                LogHelper.info((String)"[Progressive Bosses] %s first spawned. Set First Dragon to 1", (Object[])new Object[]{player.m_7755_().getString()});
            }
        });
    }
}

