/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.module.dragon.entity.Larva;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.PBEntities;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Larva", description="Mini things that are just annoying.")
public class LarvaFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> larvaAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> bonusLarvaEveryDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxSpawnedConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> reducedDragonDamageConfig;
    public int larvaAtDifficulty = 1;
    public int bonusLarvaEveryDifficulty = 1;
    public int maxSpawned = 7;
    public int minCooldown = 800;
    public int maxCooldown = 1400;
    public boolean reducedDragonDamage = true;

    public LarvaFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.larvaAtDifficultyConfig = Config.builder.comment("At which difficulty the Ender Dragon starts spawning Larvae").defineInRange("Larva at Difficulty", this.larvaAtDifficulty, 0, Integer.MAX_VALUE);
        this.bonusLarvaEveryDifficultyConfig = Config.builder.comment("As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion").defineInRange("Bonus Larva Every Difficulty", this.bonusLarvaEveryDifficulty, 0, Integer.MAX_VALUE);
        this.maxSpawnedConfig = Config.builder.comment("Maximum Larva spawned by the Ender Dragon").defineInRange("Max Larvae Spawned", this.maxSpawned, 0, Integer.MAX_VALUE);
        this.minCooldownConfig = Config.builder.comment("Minimum ticks (20 ticks = 1 seconds) after Minions can spawn.").defineInRange("Minimum Cooldown", this.minCooldown, 0, Integer.MAX_VALUE);
        this.maxCooldownConfig = Config.builder.comment("Maximum ticks (20 ticks = 1 seconds) after Minions can spawn.").defineInRange("Maximum Cooldown", this.maxCooldown, 0, Integer.MAX_VALUE);
        this.reducedDragonDamageConfig = Config.builder.comment("If true, Larvae will take only 10% damage from the Ender Dragon.").define("Reduced Dragon Damage", this.reducedDragonDamage);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.larvaAtDifficulty = (Integer)this.larvaAtDifficultyConfig.get();
        this.bonusLarvaEveryDifficulty = (Integer)this.bonusLarvaEveryDifficultyConfig.get();
        this.maxSpawned = (Integer)this.maxSpawnedConfig.get();
        this.minCooldown = (Integer)this.minCooldownConfig.get();
        this.maxCooldown = (Integer)this.maxCooldownConfig.get();
        if (this.minCooldown > this.maxCooldown) {
            this.minCooldown = this.maxCooldown;
        }
        this.reducedDragonDamage = (Boolean)this.reducedDragonDamageConfig.get();
    }

    @SubscribeEvent
    public void onDragonSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        CompoundTag dragonTags = dragon.getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt((Random)dragon.m_21187_(), (int)this.minCooldown, (int)this.maxCooldown) * 0.5);
        dragonTags.m_128405_("progressivebosses:dragon_larva_cooldown", cooldown);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        Level world = event.getEntity().f_19853_;
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        if (difficulty < (float)this.larvaAtDifficulty) {
            return;
        }
        if (dragon.m_21223_() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.m_128451_("progressivebosses:dragon_larva_cooldown");
        if (cooldown > 0) {
            dragonTags.m_128405_("progressivebosses:dragon_larva_cooldown", cooldown - 1);
            return;
        }
        BlockPos centerPodium = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB bb = new AABB(centerPodium).m_82400_(64.0);
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt((Random)world.f_46441_, (int)minCooldown, (int)maxCooldown);
        dragonTags.m_128405_("progressivebosses:dragon_larva_cooldown", cooldown - 1);
        int larvaSpawnedCount = 0;
        int i = this.larvaAtDifficulty;
        while ((float)i <= difficulty) {
            float angle = world.f_46441_.nextFloat() * (float)Math.PI * 2.0f;
            float x = (float)Math.floor(Math.cos(angle) * (double)3.33f);
            float z = (float)Math.floor(Math.sin(angle) * (double)3.33f);
            int y = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos((double)x, 255.0, (double)z)).m_123342_();
            this.summonLarva(world, new Vec3((double)x + 0.5, (double)y, (double)z + 0.5), difficulty);
            if (++larvaSpawnedCount >= this.maxSpawned) break;
            i += this.bonusLarvaEveryDifficulty;
        }
    }

    public Larva summonLarva(Level world, Vec3 pos, float difficulty) {
        Larva larva = new Larva((EntityType<? extends Larva>)((EntityType)PBEntities.LARVA.get()), world);
        CompoundTag minionTags = larva.getPersistentData();
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        larva.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        larva.m_21530_();
        MCUtils.applyModifier((LivingEntity)larva, (Attribute)Attributes.f_22281_, (UUID)Strings.AttributeModifiers.ATTACK_DAMAGE_BONUS_UUID, (String)"progressivebosses:attack_damage_bonus", (double)(0.35 * (double)difficulty), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        MCUtils.applyModifier((LivingEntity)larva, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)2.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        world.m_7967_((Entity)larva);
        return larva;
    }
}

